/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fs.command;

import alluxio.cli.fs.command.AbstractFileSystemCommand;
import alluxio.cli.fs.command.CpCommand;
import alluxio.client.file.FileSystemContext;
import alluxio.exception.AlluxioException;
import alluxio.exception.status.InvalidArgumentException;
import java.io.File;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

@ThreadSafe
public final class CopyToLocalCommand
extends AbstractFileSystemCommand {
    private CpCommand mCpCommand;

    public CopyToLocalCommand(FileSystemContext fsContext) {
        super(fsContext);
        this.mCpCommand = new CpCommand(fsContext);
    }

    public String getCommandName() {
        return "copyToLocal";
    }

    public Options getOptions() {
        return new Options().addOption(CpCommand.BUFFER_SIZE_OPTION);
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        this.mCpCommand.validateArgs(cl);
    }

    public int run(CommandLine cl) throws AlluxioException, IOException {
        String[] args = cl.getArgs();
        String dst = args[1];
        cl.getArgList().set(1, "file://" + new File(dst).getAbsolutePath());
        this.mCpCommand.run(cl);
        return 0;
    }

    public String getUsage() {
        return "copyToLocal [--buffersize <bytes>]  <src> <localDst>";
    }

    public String getDescription() {
        return "Copies a file or a directory from the Alluxio filesystem to the local filesystem.";
    }
}

