/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fs.command.AbstractFileSystemCommand;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.URIStatus;
import alluxio.exception.AlluxioException;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.FileDoesNotExistException;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.grpc.OpenFilePOptions;
import alluxio.grpc.ReadPType;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.codec.digest.DigestUtils;

@ThreadSafe
public final class ChecksumCommand
extends AbstractFileSystemCommand {
    public ChecksumCommand(FileSystemContext fsContext) {
        super(fsContext);
    }

    @Override
    protected void runPlainPath(AlluxioURI plainPath, CommandLine cl) throws AlluxioException, IOException {
        URIStatus status = this.mFileSystem.getStatus(plainPath);
        if (status.isFolder()) {
            throw new FileDoesNotExistException(ExceptionMessage.PATH_MUST_BE_FILE.getMessage(new Object[]{plainPath.getPath()}));
        }
        String str = this.calculateChecksum(plainPath);
        System.out.println("md5sum: " + str + "\n");
    }

    public String getCommandName() {
        return "checksum";
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsEquals((Command)this, (CommandLine)cl, (int)1);
    }

    public int run(CommandLine cl) throws AlluxioException, IOException {
        String[] args = cl.getArgs();
        this.runWildCardCmd(new AlluxioURI(args[0]), cl);
        return 0;
    }

    private String calculateChecksum(AlluxioURI filePath) throws AlluxioException, IOException {
        OpenFilePOptions options = OpenFilePOptions.newBuilder().setReadType(ReadPType.NO_CACHE).build();
        try (FileInStream fis = this.mFileSystem.openFile(filePath, options);){
            String string = DigestUtils.md5Hex((InputStream)fis);
            return string;
        }
    }

    public String getUsage() {
        return "checksum <Alluxio path>";
    }

    public String getDescription() {
        return "Calculates the md5 checksum of a file in the Alluxio filesystem.";
    }
}

