/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fs.command;

import alluxio.AlluxioURI;
import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fs.command.AbstractFileSystemCommand;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.FileSystemMasterClient;
import alluxio.client.file.URIStatus;
import alluxio.collections.ConcurrentHashSet;
import alluxio.conf.AlluxioConfiguration;
import alluxio.exception.AggregateException;
import alluxio.exception.AlluxioException;
import alluxio.exception.status.InvalidArgumentException;
import alluxio.grpc.CheckConsistencyPOptions;
import alluxio.grpc.DeletePOptions;
import alluxio.resource.CloseableResource;
import alluxio.util.FileSystemOptions;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class CheckConsistencyCommand
extends AbstractFileSystemCommand {
    private static final Option REPAIR_OPTION = Option.builder((String)"r").required(false).hasArg(false).desc("repair inconsistent files").build();
    private static final Option THREADS_OPTION = Option.builder((String)"t").longOpt("threads").required(false).hasArg(true).desc("Number of threads used when repairing consistency. Defaults to <number of cores> * 2. This option has no effect if -r is not specified").build();
    private static final String PARSE_THREADS_FAILURE_FMT = "The threads option must be a positive integer but was \"%s\"";

    public CheckConsistencyCommand(FileSystemContext fsContext) {
        super(fsContext);
    }

    @Override
    protected void runPlainPath(AlluxioURI plainPath, CommandLine cl) throws AlluxioException, IOException {
        int threads;
        try {
            int n = threads = cl.hasOption(THREADS_OPTION.getOpt()) ? Integer.parseInt(cl.getOptionValue(THREADS_OPTION.getOpt())) : Runtime.getRuntime().availableProcessors() * 2;
            if (threads < 1) {
                throw new IOException(String.format(PARSE_THREADS_FAILURE_FMT, THREADS_OPTION.getOpt()));
            }
        }
        catch (NumberFormatException e) {
            throw new IOException(String.format(PARSE_THREADS_FAILURE_FMT, THREADS_OPTION.getOpt()));
        }
        this.runConsistencyCheck(plainPath, cl.hasOption("r"), threads);
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsEquals((Command)this, (CommandLine)cl, (int)1);
    }

    public Options getOptions() {
        return new Options().addOption(REPAIR_OPTION).addOption(THREADS_OPTION);
    }

    public String getCommandName() {
        return "checkConsistency";
    }

    public int run(CommandLine cl) throws AlluxioException, IOException {
        String[] args = cl.getArgs();
        AlluxioURI root = new AlluxioURI(args[0]);
        this.runWildCardCmd(root, cl);
        return 0;
    }

    List<AlluxioURI> checkConsistency(AlluxioURI path, CheckConsistencyPOptions options) throws IOException {
        try (CloseableResource client = this.mFsContext.acquireMasterClientResource();){
            List list = ((FileSystemMasterClient)client.get()).checkConsistency(path, options);
            return list;
        }
    }

    private void runConsistencyCheck(AlluxioURI path, boolean repairConsistency, int repairThreads) throws AlluxioException, IOException {
        List<AlluxioURI> inconsistentUris = this.checkConsistency(path, FileSystemOptions.checkConsistencyDefaults((AlluxioConfiguration)this.mFsContext.getPathConf(path)));
        if (inconsistentUris.isEmpty()) {
            System.out.println(path + " is consistent with the under storage system.");
            return;
        }
        if (!repairConsistency) {
            Collections.sort(inconsistentUris);
            System.out.println("The following files are inconsistent:");
            for (AlluxioURI uri : inconsistentUris) {
                System.out.println(uri);
            }
        } else {
            Collections.sort(inconsistentUris);
            System.out.println(String.format("%s has: %d inconsistent files. Repairing with %d threads.", path, inconsistentUris.size(), repairThreads));
            ConcurrentHashSet inconsistentDirs = new ConcurrentHashSet();
            ExecutorService svc = Executors.newFixedThreadPool(repairThreads);
            ExecutorCompletionService<Boolean> completionService = new ExecutorCompletionService<Boolean>(svc);
            ConcurrentHashSet exceptions = new ConcurrentHashSet();
            int totalUris = inconsistentUris.size();
            for (AlluxioURI inconsistentUri : inconsistentUris) {
                completionService.submit(() -> {
                    try {
                        URIStatus status = this.mFileSystem.getStatus(inconsistentUri);
                        if (status.isFolder()) {
                            inconsistentDirs.add((Object)inconsistentUri);
                            return;
                        }
                        System.out.println("repairing path: " + inconsistentUri);
                        DeletePOptions deleteOptions = DeletePOptions.newBuilder().setAlluxioOnly(true).build();
                        this.mFileSystem.delete(inconsistentUri, deleteOptions);
                        this.mFileSystem.exists(inconsistentUri);
                        System.out.println(inconsistentUri + " repaired");
                        System.out.println();
                    }
                    catch (AlluxioException | IOException e) {
                        exceptions.add((Object)e);
                    }
                }, true);
            }
            this.waitForTasks(completionService, totalUris, (Collection<Exception>)exceptions);
            int totalDirs = inconsistentDirs.size();
            for (AlluxioURI uri : inconsistentDirs) {
                completionService.submit(() -> {
                    try {
                        DeletePOptions deleteOptions = DeletePOptions.newBuilder().setAlluxioOnly(true).setRecursive(true).build();
                        System.out.println("repairing path: " + uri);
                        this.mFileSystem.delete(uri, deleteOptions);
                        this.mFileSystem.exists(uri);
                        System.out.println(uri + "repaired");
                        System.out.println();
                    }
                    catch (AlluxioException | IOException e) {
                        exceptions.add((Object)e);
                    }
                }, true);
            }
            this.waitForTasks(completionService, totalDirs, (Collection<Exception>)exceptions);
            svc.shutdown();
        }
    }

    private void waitForTasks(CompletionService svc, int nTasks, Collection<Exception> exceptions) throws IOException {
        for (int i = 0; i < nTasks; ++i) {
            try {
                svc.take();
                continue;
            }
            catch (InterruptedException e) {
                throw new IOException("Failed to wait for all URIs to complete");
            }
        }
        if (exceptions.size() > 0) {
            AggregateException e = new AggregateException(exceptions);
            throw new IOException("Failed to successfully repair all paths", (Throwable)e);
        }
    }

    public String getUsage() {
        return "checkConsistency [-r] [-t|--threads <threads>] <Alluxio path>";
    }

    public String getDescription() {
        return "Checks the consistency of a persisted file or directory in Alluxio. Any files or directories which only exist in Alluxio or do not match the metadata of files in the under storage will be returned. An administrator should then reconcile the  differences. Specify -r to repair the inconsistent files. Use -t or --threads to specify the number of threads that should be used when repairing. Defaults to 2*<number of CPU cores>";
    }
}

