/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.fs;

import alluxio.AlluxioURI;
import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.fs.FileSystemShell;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.URIStatus;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.AlluxioException;
import alluxio.exception.ExceptionMessage;
import alluxio.util.FormatUtils;
import alluxio.util.io.PathUtils;
import alluxio.util.network.NetworkAddressUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

@ThreadSafe
public final class FileSystemShellUtils {
    private FileSystemShellUtils() {
    }

    public static String getFilePath(String path, AlluxioConfiguration alluxioConf) throws IOException {
        if ((path = FileSystemShellUtils.validatePath(path, alluxioConf)).startsWith("alluxio://")) {
            path = path.substring("alluxio://".length());
        }
        return path.substring(path.indexOf("/"));
    }

    public static String validatePath(String path, AlluxioConfiguration alluxioConf) throws IOException {
        if (path.startsWith("alluxio://")) {
            if (!path.contains(":")) {
                throw new IOException("Invalid Path: " + path + ". Use " + "alluxio://" + "host:port/ , or /file");
            }
            return path;
        }
        String hostname = NetworkAddressUtils.getConnectHost((NetworkAddressUtils.ServiceAttributeProvider)NetworkAddressUtils.ServiceType.MASTER_RPC, (AlluxioConfiguration)alluxioConf);
        int port = alluxioConf.getInt(PropertyKey.MASTER_RPC_PORT);
        return PathUtils.concatPath((Object)("alluxio://" + hostname + ":" + port), (Object)path);
    }

    public static List<AlluxioURI> getAlluxioURIs(FileSystem alluxioClient, AlluxioURI inputURI) throws IOException {
        if (!inputURI.getPath().contains("*")) {
            return Lists.newArrayList((Object[])new AlluxioURI[]{inputURI});
        }
        String inputPath = inputURI.getPath();
        AlluxioURI parentURI = new AlluxioURI(inputURI.getScheme(), inputURI.getAuthority(), inputPath.substring(0, inputPath.indexOf("*") + 1), inputURI.getQueryMap()).getParent();
        return FileSystemShellUtils.getAlluxioURIs(alluxioClient, inputURI, parentURI);
    }

    private static List<AlluxioURI> getAlluxioURIs(FileSystem alluxioClient, AlluxioURI inputURI, AlluxioURI parentDir) throws IOException {
        List statuses;
        ArrayList<AlluxioURI> res = new ArrayList<AlluxioURI>();
        try {
            statuses = alluxioClient.listStatus(parentDir);
        }
        catch (AlluxioException e) {
            throw new IOException(e);
        }
        for (URIStatus status : statuses) {
            AlluxioURI dirURI;
            String prefix;
            AlluxioURI fileURI = new AlluxioURI(inputURI.getScheme(), inputURI.getAuthority(), status.getPath());
            if (FileSystemShellUtils.match(fileURI, inputURI)) {
                res.add(fileURI);
                continue;
            }
            if (!status.isFolder() || (prefix = inputURI.getLeadingPath((dirURI = new AlluxioURI(inputURI.getScheme(), inputURI.getAuthority(), status.getPath())).getDepth())) == null || !FileSystemShellUtils.match(dirURI, new AlluxioURI(prefix))) continue;
            res.addAll(FileSystemShellUtils.getAlluxioURIs(alluxioClient, inputURI, dirURI));
        }
        return res;
    }

    public static List<File> getFiles(String inputPath) {
        File file = new File(inputPath);
        if (!inputPath.contains("*")) {
            ArrayList<File> res = new ArrayList<File>();
            if (file.exists()) {
                res.add(file);
            }
            return res;
        }
        String prefix = inputPath.substring(0, inputPath.indexOf("*") + 1);
        String parent = new File(prefix).getParent();
        return FileSystemShellUtils.getFiles(inputPath, parent);
    }

    private static List<File> getFiles(String inputPath, String parent) {
        ArrayList<File> res = new ArrayList<File>();
        File pFile = new File(parent);
        if (!pFile.exists() || !pFile.isDirectory()) {
            return res;
        }
        if (pFile.isDirectory() && pFile.canRead()) {
            File[] fileList = pFile.listFiles();
            if (fileList == null) {
                return res;
            }
            for (File file : fileList) {
                AlluxioURI dirURI;
                String prefix;
                if (FileSystemShellUtils.match(file.getPath(), inputPath)) {
                    res.add(file);
                    continue;
                }
                if (!file.isDirectory() || (prefix = new AlluxioURI(inputPath).getLeadingPath((dirURI = new AlluxioURI(file.getPath())).getDepth())) == null || !FileSystemShellUtils.match(dirURI, new AlluxioURI(prefix))) continue;
                res.addAll(FileSystemShellUtils.getFiles(inputPath, dirURI.getPath()));
            }
        }
        return res;
    }

    public static boolean getBoolArg(CommandLine cl, Option option, boolean defaultValue) {
        boolean arg = defaultValue;
        if (cl.hasOption(option.getLongOpt())) {
            String argOption = cl.getOptionValue(option.getLongOpt());
            arg = Boolean.parseBoolean(argOption);
        }
        return arg;
    }

    public static int getIntArg(CommandLine cl, Option option, int defaultValue) {
        int arg = defaultValue;
        if (cl.hasOption(option.getLongOpt())) {
            String argOption = cl.getOptionValue(option.getLongOpt());
            arg = Integer.parseInt(argOption);
        }
        return arg;
    }

    public static long getMsArg(CommandLine cl, Option option, long defaultValue) {
        long arg = defaultValue;
        if (cl.hasOption(option.getLongOpt())) {
            String argOption = cl.getOptionValue(option.getLongOpt());
            arg = FormatUtils.parseTimeSize((String)argOption);
        }
        return arg;
    }

    public static Map<String, Command> loadCommands(FileSystemContext fsContext) {
        return CommandUtils.loadCommands((String)FileSystemShell.class.getPackage().getName(), (Class[])new Class[]{FileSystemContext.class}, (Object[])new Object[]{fsContext});
    }

    public static long getMs(String time) {
        try {
            return FormatUtils.parseTimeSize((String)time);
        }
        catch (Exception e) {
            throw new RuntimeException(ExceptionMessage.INVALID_TIME.getMessage(new Object[]{time}));
        }
    }

    private static String escape(String str) {
        return str.replace(".", "%2E").replace("+", "%2B").replace("^", "%5E").replace("$", "%24").replace("*", "%2A");
    }

    private static String replaceWildcards(String text) {
        return FileSystemShellUtils.escape(text).replace("%2A", ".*");
    }

    private static boolean match(AlluxioURI fileURI, AlluxioURI patternURI) {
        return FileSystemShellUtils.escape(fileURI.getPath()).matches(FileSystemShellUtils.replaceWildcards(patternURI.getPath()));
    }

    public static boolean match(String filePath, String patternPath) {
        return FileSystemShellUtils.match(new AlluxioURI(filePath), new AlluxioURI(patternPath));
    }
}

