/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.bundler.command;

import alluxio.cli.bundler.command.AbstractCollectInfoCommand;
import alluxio.client.file.FileSystemContext;
import alluxio.exception.AlluxioException;
import alluxio.shell.CommandReturn;
import alluxio.shell.ShellCommand;
import alluxio.util.ShellUtils;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExecuteShellCollectInfoCommand
extends AbstractCollectInfoCommand {
    private static final Logger LOG = LoggerFactory.getLogger(ExecuteShellCollectInfoCommand.class);
    protected Map<String, ShellCommand> mCommands = new HashMap<String, ShellCommand>();
    protected Map<String, ShellCommand> mCommandsAlt = new HashMap<String, ShellCommand>();

    public ExecuteShellCollectInfoCommand(FileSystemContext fsContext) {
        super(fsContext);
    }

    protected abstract void registerCommands();

    protected void registerCommand(String name, ShellCommand cmd, ShellCommand alternativeCmd) {
        this.mCommands.put(name, cmd);
        if (alternativeCmd != null) {
            this.mCommandsAlt.put(name, alternativeCmd);
        }
    }

    public int run(CommandLine cl) throws AlluxioException, IOException {
        this.mWorkingDirPath = this.getWorkingDirectory(cl);
        StringWriter outputBuffer = new StringWriter();
        for (Map.Entry<String, ShellCommand> entry : this.mCommands.entrySet()) {
            String cmdName = entry.getKey();
            ShellCommand cmd = entry.getValue();
            ShellCommand backupCmd = this.mCommandsAlt.getOrDefault(cmdName, null);
            CommandReturn cr = ShellUtils.execCmdWithBackup((ShellCommand)cmd, (ShellCommand)backupCmd);
            outputBuffer.write(cr.getFormattedOutput());
            if (cr.getExitCode() == 0) continue;
            LOG.warn("Command {} failed with exit code {}", (Object)cmdName, (Object)cr.getExitCode());
        }
        File outputFile = this.generateOutputFile(this.mWorkingDirPath, String.format("%s.txt", this.getCommandName()));
        LOG.info(String.format("Finished all commands. Writing to output file %s", outputFile.getAbsolutePath()));
        FileUtils.writeStringToFile((File)outputFile, (String)outputBuffer.toString());
        return 0;
    }
}

