/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.bundler.command;

import alluxio.cli.bundler.command.AbstractCollectInfoCommand;
import alluxio.client.block.BlockWorkerInfo;
import alluxio.client.file.FileSystemContext;
import alluxio.conf.PropertyKey;
import alluxio.exception.AlluxioException;
import alluxio.exception.status.UnavailableException;
import alluxio.util.SleepUtils;
import alluxio.util.network.HttpUtils;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectMetricsCommand
extends AbstractCollectInfoCommand {
    public static final String COMMAND_NAME = "collectMetrics";
    private static final Logger LOG = LoggerFactory.getLogger(CollectMetricsCommand.class);
    private static final int COLLECT_METRICS_INTERVAL = 3000;
    private static final int COLLECT_METRICS_TIMES = 3;
    private static final int COLLECT_METRICS_TIMEOUT = 5000;
    private static final String METRICS_SERVLET_PATH = "/metrics/json/";
    private static final String EXCLUDE_OPTION_NAME = "exclude-worker-metrics";
    private static final Option ONLY_MASTER_OPTION = Option.builder().required(false).longOpt("exclude-worker-metrics").hasArg(false).desc("only collect master metrics\nBy default collect master metrics and all worker metrics.").build();
    public static final Options OPTIONS = new Options().addOption(ONLY_MASTER_OPTION);

    public CollectMetricsCommand(FileSystemContext fsContext) {
        super(fsContext);
    }

    public String getCommandName() {
        return COMMAND_NAME;
    }

    public int run(CommandLine cl) throws AlluxioException, IOException {
        this.mWorkingDirPath = this.getWorkingDirectory(cl);
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss");
        StringWriter outputBuffer = new StringWriter();
        for (int i = 0; i < 3; ++i) {
            LocalDateTime now = LocalDateTime.now();
            String masterMsg = String.format("Collecting master metrics at %s ", dtf.format(now));
            LOG.info(masterMsg);
            outputBuffer.write(masterMsg);
            this.masterMetrics(outputBuffer, i);
            if (!cl.hasOption(EXCLUDE_OPTION_NAME)) {
                String workerMsg = String.format("Collecting worker metrics at %s ", dtf.format(now));
                LOG.info(workerMsg);
                outputBuffer.write(workerMsg);
                this.workerMetrics(outputBuffer, i);
            }
            SleepUtils.sleepMs((Logger)LOG, (long)3000L);
        }
        File outputFile = this.generateOutputFile(this.mWorkingDirPath, String.format("%s.txt", this.getCommandName()));
        FileUtils.writeStringToFile((File)outputFile, (String)outputBuffer.toString());
        return 0;
    }

    private void masterMetrics(StringWriter outputBuffer, int i) throws IOException {
        String metricsResponse;
        String masterAddr;
        try {
            masterAddr = this.mFsContext.getMasterAddress().getHostName();
        }
        catch (UnavailableException e) {
            String noMasterMsg = "No Alluxio master available. Skip metrics collection.";
            LOG.warn(noMasterMsg);
            outputBuffer.write(noMasterMsg);
            return;
        }
        String url = String.format("http://%s:%s%s", masterAddr, this.mFsContext.getClusterConf().get(PropertyKey.MASTER_WEB_PORT), METRICS_SERVLET_PATH);
        LOG.info(String.format("Metric address URL: %s", url));
        try {
            metricsResponse = this.getMetricsJson(url);
        }
        catch (Exception e) {
            LOG.error("Failed to get Alluxio master metrics from URL {}. Exception: ", (Object)url, (Object)e);
            metricsResponse = String.format("Url: %s%nError: %s", url, e.getMessage());
        }
        outputBuffer.write(metricsResponse);
        outputBuffer.write("\n");
        File outputFile = this.generateOutputFile(this.mWorkingDirPath, String.format("%s-master-%s", this.getCommandName(), i));
        FileUtils.writeStringToFile((File)outputFile, (String)metricsResponse);
    }

    private void workerMetrics(StringWriter outputBuffer, int i) throws IOException {
        List workers;
        try {
            workers = this.mFsContext.getCachedWorkers();
        }
        catch (UnavailableException e) {
            String noWorkerMsg = "No Alluxio workers available. Skip metrics collection.";
            LOG.warn(noWorkerMsg);
            outputBuffer.write(noWorkerMsg);
            return;
        }
        for (BlockWorkerInfo worker : workers) {
            String metricsResponse;
            String url = String.format("http://%s:%s%s", worker.getNetAddress().getHost(), this.mFsContext.getClusterConf().get(PropertyKey.WORKER_WEB_PORT), METRICS_SERVLET_PATH);
            LOG.info(String.format("Metric address URL: %s", url));
            try {
                metricsResponse = this.getMetricsJson(url);
            }
            catch (Exception e) {
                LOG.error("Failed to get Alluxio worker metrics from URL {}. Exception: ", (Object)url, (Object)e);
                metricsResponse = String.format("Url: %s%nError: %s", url, e.getMessage());
            }
            outputBuffer.write(metricsResponse);
            outputBuffer.write("\n");
            File outputFile = this.generateOutputFile(this.mWorkingDirPath, String.format("%s-worker-%s", this.getCommandName(), i));
            FileUtils.writeStringToFile((File)outputFile, (String)metricsResponse);
        }
    }

    public String getUsage() {
        return "collectMetrics <outputPath>";
    }

    public String getDescription() {
        return "Collect Alluxio metrics";
    }

    public String getMetricsJson(String url) throws IOException {
        String responseJson = HttpUtils.get((String)url, (Integer)5000);
        return String.format("Url: %s%nResponse: %s", url, responseJson);
    }
}

