/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.bundler.command;

import alluxio.cli.bundler.command.AbstractCollectInfoCommand;
import alluxio.client.file.FileSystemContext;
import alluxio.conf.PropertyKey;
import alluxio.exception.AlluxioException;
import alluxio.util.CommonUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectLogCommand
extends AbstractCollectInfoCommand {
    public static final String COMMAND_NAME = "collectLog";
    private static final Logger LOG = LoggerFactory.getLogger(CollectLogCommand.class);
    public static final Set<String> FILE_NAMES_PREFIXES = Stream.of("master.log", "master.out", "job_master.log", "job_master.out", "master_audit.log", "worker.log", "worker.out", "job_worker.log", "job_worker.out", "fuse.log", "fuse.out", "proxy.log", "proxy.out", "task.log", "task.out", "user").collect(Collectors.toSet());
    private static final int TRY_PARSE_LOG_ROWS = 100;
    private static final Map<DateTimeFormatter, Integer> FORMATTERS = new LinkedHashMap<DateTimeFormatter, Integer>(){
        {
            this.put(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss,SSS"), 23);
            this.put(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"), 19);
            this.put(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm"), 16);
            this.put(DateTimeFormatter.ofPattern("yy/MM/dd HH:mm:ss"), 17);
            this.put(DateTimeFormatter.ofPattern("yy/MM/dd HH:mm"), 14);
            this.put(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSXX"), 28);
            this.put(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss"), 19);
            this.put(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm"), 16);
        }
    };
    private String mLogDirPath;
    private File mLogDir;
    private URI mLogDirUri;
    private Set<String> mIncludedPrefix;
    private Set<String> mExcludedPrefix;
    private LocalDateTime mStartTime;
    private LocalDateTime mEndTime;
    public static final String INCLUDE_OPTION_NAME = "include-logs";
    public static final String EXCLUDE_OPTION_NAME = "exclude-logs";
    public static final String ADDITIONAL_OPTION_NAME = "additional-logs";
    private static final Option INCLUDE_OPTION = Option.builder().required(false).argName("filename-prefixes").longOpt("include-logs").hasArg(true).desc(String.format("extra log file name prefixes to include in ${ALLUXIO_HOME}/logs. Only the files that start with the prefix will be included.%nThis option should not be given in combination with --%s or --%s.%n<filename-prefixes> filename prefixes, separated by comma", "exclude-logs", "additional-logs")).build();
    private static final Option EXCLUDE_OPTION = Option.builder().required(false).argName("filename-prefixes").longOpt("exclude-logs").hasArg(true).desc(String.format("log file name prefixes to exclude in ${ALLUXIO_HOME}/logs. The files that start with the prefix will be excluded.%nThis will be checked before the additions defined in --%s.%n<filename-prefixes> filename prefixes, separated by comma", "additional-logs")).build();
    private static final Option ADDITIONAL_OPTION = Option.builder().required(false).argName("filename-prefixes").longOpt("additional-logs").hasArg(true).desc(String.format("extra log file name prefixes to include in ${ALLUXIO_HOME}/logs. The files that start with the prefix will be included, in addition to the rest of regular logs like master.log.%nThis will be checked after the exclusions defined in --%s.%n<filename-prefixes> filename prefixes, separated by comma", "exclude-logs")).build();
    private static final String START_OPTION_NAME = "start-time";
    private static final Option START_OPTION = Option.builder().required(false).argName("datetime").longOpt("start-time").hasArg(true).desc("logs that do not contain entries after this time will be ignored\n<datetime> a datetime string like 2020-06-27T11:58:53 or \"2020-06-27 11:58:53\"").build();
    private static final String END_OPTION_NAME = "end-time";
    private static final Option END_OPTION = Option.builder().required(false).argName("datetime").longOpt("end-time").hasArg(true).desc("logs that do not contain entries before this time will be ignored\n<datetime> a datetime string like 2020-06-27T11:58:53").build();
    public static final Options OPTIONS = new Options().addOption(INCLUDE_OPTION).addOption(EXCLUDE_OPTION).addOption(ADDITIONAL_OPTION).addOption(START_OPTION).addOption(END_OPTION);

    public CollectLogCommand(FileSystemContext fsContext) {
        super(fsContext);
        this.mLogDirPath = fsContext.getClusterConf().getString(PropertyKey.LOGS_DIR);
        this.mLogDir = new File(this.mLogDirPath);
        this.mLogDirUri = this.mLogDir.toURI();
    }

    public String getCommandName() {
        return COMMAND_NAME;
    }

    public int run(CommandLine cl) throws AlluxioException, IOException {
        Set<String> toInclude;
        this.mWorkingDirPath = this.getWorkingDirectory(cl);
        this.mIncludedPrefix = new HashSet<String>(FILE_NAMES_PREFIXES);
        boolean listReplaced = false;
        if (cl.hasOption(INCLUDE_OPTION_NAME)) {
            toInclude = CollectLogCommand.parseFileNames(cl.getOptionValue(INCLUDE_OPTION_NAME));
            System.out.format("Only include the following filename prefixes: %s%n", toInclude);
            this.mIncludedPrefix = toInclude;
            listReplaced = true;
        }
        if (cl.hasOption(EXCLUDE_OPTION_NAME)) {
            if (listReplaced) {
                System.err.format("ERROR: Please do not use --%s when --%s is specified.%n", EXCLUDE_OPTION_NAME, INCLUDE_OPTION_NAME);
                return -1;
            }
            this.mExcludedPrefix = CollectLogCommand.parseFileNames(cl.getOptionValue(EXCLUDE_OPTION_NAME));
            System.out.format("Exclude the following filename prefixes: %s%n", this.mExcludedPrefix);
        }
        if (cl.hasOption(ADDITIONAL_OPTION_NAME)) {
            if (listReplaced) {
                System.err.format("ERROR: Please do not use --%s when --%s is specified.%n", ADDITIONAL_OPTION_NAME, INCLUDE_OPTION_NAME);
                return -1;
            }
            toInclude = CollectLogCommand.parseFileNames(cl.getOptionValue(ADDITIONAL_OPTION_NAME));
            System.out.format("Additionally, include the following filename prefixes: %s%n", toInclude);
            this.mIncludedPrefix.addAll(toInclude);
        }
        boolean checkTimeStamp = false;
        if (cl.hasOption(START_OPTION_NAME)) {
            String startTimeStr = cl.getOptionValue(START_OPTION_NAME);
            this.mStartTime = CollectLogCommand.parseDateTime(startTimeStr);
            System.out.format("Time window start: %s%n", this.mStartTime);
            checkTimeStamp = true;
        }
        if (cl.hasOption(END_OPTION_NAME)) {
            String endTimeStr = cl.getOptionValue(END_OPTION_NAME);
            this.mEndTime = CollectLogCommand.parseDateTime(endTimeStr);
            System.out.format("Time window end: %s%n", this.mEndTime);
            checkTimeStamp = true;
        }
        if (this.mStartTime != null && this.mEndTime != null && this.mStartTime.isAfter(this.mEndTime)) {
            System.err.format("ERROR: Start time %s is later than end time %s!%n", this.mStartTime, this.mEndTime);
        }
        if (!this.mLogDir.exists()) {
            System.err.format("ERROR: Alluxio log directory %s does not exist!%n", this.mLogDirPath);
            return -1;
        }
        List allFiles = CommonUtils.recursiveListLocalDir((File)this.mLogDir);
        for (File f : allFiles) {
            String relativePath = this.getRelativePathToLogDir(f);
            try {
                if (!this.shouldCopy(f, relativePath, checkTimeStamp)) continue;
                File targetFile = new File(this.mWorkingDirPath, relativePath);
                FileUtils.copyFile((File)f, (File)targetFile, (boolean)true);
            }
            catch (IOException e) {
                System.err.format("ERROR: file %s not found %s%n", f.getCanonicalPath(), e.getMessage());
            }
        }
        return 0;
    }

    private String getRelativePathToLogDir(File f) {
        return this.mLogDirUri.relativize(f.toURI()).getPath();
    }

    private boolean shouldCopy(File f, String relativePath, boolean checkTimeStamp) throws IOException {
        if (!this.fileNameIsWanted(relativePath)) {
            return false;
        }
        return !checkTimeStamp || this.fileTimeStampIsWanted(f);
    }

    private boolean fileNameIsWanted(String fileName) {
        if (this.mExcludedPrefix != null) {
            for (String x : this.mExcludedPrefix) {
                if (!fileName.startsWith(x)) continue;
                return false;
            }
        }
        for (String s : this.mIncludedPrefix) {
            if (!fileName.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    private boolean fileTimeStampIsWanted(File f) throws IOException {
        long timestamp;
        LocalDateTime fileEndTime;
        if (this.mStartTime != null && this.mStartTime.isAfter(fileEndTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp = f.lastModified()), ZoneId.systemDefault()))) {
            return false;
        }
        if (this.mEndTime != null) {
            LocalDateTime fileStartTime = CollectLogCommand.inferFileStartTime(f);
            if (fileStartTime == null) {
                fileStartTime = LocalDateTime.MIN;
            }
            if (this.mEndTime.isBefore(fileStartTime)) {
                return false;
            }
        }
        return true;
    }

    public static LocalDateTime inferFileStartTime(File f) throws FileNotFoundException {
        try (Scanner scanner = new Scanner(f);){
            for (int r = 0; scanner.hasNextLine() && r < 100; ++r) {
                String line = scanner.nextLine();
                LocalDateTime datetime = CollectLogCommand.parseDateTime(line);
                if (datetime == null) continue;
                LocalDateTime localDateTime = datetime;
                return localDateTime;
            }
        }
        return null;
    }

    private static Set<String> parseFileNames(String input) {
        HashSet<String> names = new HashSet<String>();
        names.addAll(Stream.of(input.split(",")).map(String::trim).collect(Collectors.toList()));
        return names;
    }

    public String getUsage() {
        return "collectLogs <outputPath>";
    }

    public String getDescription() {
        return "Collect Alluxio log files";
    }

    @Nullable
    public static LocalDateTime parseDateTime(String s) {
        for (Map.Entry<DateTimeFormatter, Integer> entry : FORMATTERS.entrySet()) {
            DateTimeFormatter fmt = entry.getKey();
            int len = entry.getValue();
            try {
                if (s.length() < len) continue;
                String datePart = s.substring(0, len);
                LocalDateTime datetime = LocalDateTime.parse(datePart, fmt);
                return datetime;
            }
            catch (DateTimeParseException e) {
            }
        }
        LOG.warn("Unknown date format in {}", (Object)(s.length() > 50 ? s.substring(0, 50) : s));
        return null;
    }
}

