/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.bundler.command;

import alluxio.cli.bundler.command.AbstractCollectInfoCommand;
import alluxio.client.file.FileSystemContext;
import alluxio.conf.PropertyKey;
import alluxio.exception.AlluxioException;
import alluxio.util.CommonUtils;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectConfigCommand
extends AbstractCollectInfoCommand {
    public static final String COMMAND_NAME = "collectConfig";
    private static final Logger LOG = LoggerFactory.getLogger(CollectConfigCommand.class);
    private static final Set<String> EXCLUDED_FILE_PREFIXES = ImmutableSet.of((Object)"alluxio-site.properties");

    public CollectConfigCommand(FileSystemContext fsContext) {
        super(fsContext);
    }

    public String getCommandName() {
        return COMMAND_NAME;
    }

    public int run(CommandLine cl) throws AlluxioException, IOException {
        this.mWorkingDirPath = this.getWorkingDirectory(cl);
        String confDirPath = this.mFsContext.getClusterConf().getString(PropertyKey.CONF_DIR);
        File confDir = new File(confDirPath);
        List allFiles = CommonUtils.recursiveListLocalDir((File)confDir);
        for (File f : allFiles) {
            String filename = f.getName();
            String relativePath = confDir.toURI().relativize(f.toURI()).getPath();
            if (EXCLUDED_FILE_PREFIXES.stream().anyMatch(filename::startsWith)) continue;
            File targetFile = new File(this.mWorkingDirPath, relativePath);
            FileUtils.copyFile((File)f, (File)targetFile, (boolean)true);
        }
        return 0;
    }

    public String getUsage() {
        return "collectConfig <outputPath>";
    }

    public String getDescription() {
        return "Collect Alluxio configurations files";
    }
}

