/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.bundler.command;

import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.client.file.FileSystemContext;
import alluxio.exception.status.InvalidArgumentException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import org.apache.commons.cli.CommandLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCollectInfoCommand
implements Command {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCollectInfoCommand.class);
    protected FileSystemContext mFsContext;
    protected String mWorkingDirPath;

    public AbstractCollectInfoCommand(FileSystemContext fsContext) {
        this.mFsContext = fsContext;
    }

    public void validateArgs(CommandLine cl) throws InvalidArgumentException {
        CommandUtils.checkNumOfArgsEquals((Command)this, (CommandLine)cl, (int)1);
    }

    public String getWorkingDirectory(CommandLine cl) {
        String[] args = cl.getArgs();
        String baseDirPath = args[1];
        String workingDirPath = Paths.get(baseDirPath, this.getCommandName()).toString();
        LOG.debug("Command {} works in {}", (Object)this.getCommandName(), (Object)workingDirPath);
        File workingDir = new File(workingDirPath);
        if (!workingDir.exists()) {
            System.out.format("Creating working directory: %s%n", workingDirPath);
            workingDir.mkdirs();
        }
        return workingDirPath;
    }

    public File generateOutputFile(String workingDirPath, String fileName) throws IOException {
        String outputFilePath = Paths.get(workingDirPath, fileName).toString();
        File outputFile = new File(outputFilePath);
        if (!outputFile.exists()) {
            outputFile.createNewFile();
        }
        return outputFile;
    }
}

