/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli.bundler;

import alluxio.cli.AbstractShell;
import alluxio.cli.Command;
import alluxio.cli.CommandUtils;
import alluxio.cli.bundler.TarUtils;
import alluxio.cli.bundler.command.AbstractCollectInfoCommand;
import alluxio.client.file.FileSystemContext;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.conf.Source;
import alluxio.exception.AlluxioException;
import alluxio.shell.CommandReturn;
import alluxio.util.ConfigurationUtils;
import alluxio.util.ShellUtils;
import alluxio.util.io.FileUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.ArrayUtils;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectInfo
extends AbstractShell {
    private static final Logger LOG = LoggerFactory.getLogger(CollectInfo.class);
    private static final String USAGE = "collectInfo [--max-threads <threadNum>] [--local] [--help] [--exclude-worker-metrics][--exclude-logs <filename-prefixes>] [--include-logs <filename-prefixes>] [--additional-logs <filename-prefixes>] [--start-time <datetime>] [--end-time <datetime>] COMMAND <outputPath>\n\ncollectInfo runs a set of sub-commands which collect information about your Alluxio cluster.\nIn the end of the run, the collected information will be written to files and bundled into one tarball.\nCOMMAND can be one of the following values:\nall:                runs all the commands below.\ncollectAlluxioInfo: runs a set of Alluxio commands to collect information about the Alluxio cluster.\ncollectConfig:      collects the configuration files under ${ALLUXIO_HOME}/config/.\ncollectEnv:         runs a set of linux commands to collect information about the cluster.\ncollectJvmInfo:     collects jstack from the JVMs.\ncollectLog:         collects the log files under ${ALLUXIO_HOME}/logs/.\ncollectMetrics:     collects Alluxio system metrics.\n\n<outputPath>        the directory you want the collected tarball to be in\n\nWARNING: This command MAY bundle credentials. To understand the risks refer to the docs here.\nhttps://docs.alluxio.io/os/user/edge/en/operation/Troubleshooting.html#collect-alluxio-cluster-information\n";
    private static final String FINAL_TARBALL_NAME = "alluxio-cluster-info-%s.tar.gz";
    private static final Map<String, String[]> CMD_ALIAS = ImmutableMap.of();
    private static final Set<String> UNSTABLE_ALIAS = ImmutableSet.of();
    private static final String TARBALL_NAME = "alluxio-info.tar.gz";
    private ExecutorService mExecutor;
    private static final String MAX_THREAD_OPTION_NAME = "max-threads";
    private static final Option THREAD_NUM_OPTION = Option.builder().required(false).longOpt("max-threads").hasArg(true).desc("the number of threads this command uses\nBy default it allocates one thread for each host.\nUse a smaller number to constrain the network IO when transmitting tarballs.").build();
    private static final String LOCAL_OPTION_NAME = "local";
    private static final Option LOCAL_OPTION = Option.builder().required(false).longOpt("local").hasArg(false).desc("specifies this command should only collect information about the localhost").build();
    private static final String HELP_OPTION_NAME = "help";
    private static final Option HELP_OPTION = Option.builder().required(false).longOpt("help").hasArg(false).desc("shows the help message").build();
    private static final Options OPTIONS = CollectInfo.loadOptions(new Options().addOption(THREAD_NUM_OPTION).addOption(LOCAL_OPTION).addOption(HELP_OPTION));

    private static Options loadOptions(Options options) {
        Reflections reflections = new Reflections(Command.class.getPackage().getName(), new Scanner[0]);
        for (Class cls : reflections.getSubTypesOf(Command.class)) {
            try {
                for (Field f : cls.getDeclaredFields()) {
                    Options clsOptions;
                    if (!f.getName().equals("OPTIONS") || (clsOptions = (Options)f.get(null)) == null) continue;
                    for (Option o : clsOptions.getOptions()) {
                        options.addOption(o);
                    }
                }
            }
            catch (IllegalAccessException e) {
                LOG.warn("Failed to load OPTIONS from class {}: {}", (Object)cls.getCanonicalName(), (Object)e.getMessage());
            }
        }
        return options;
    }

    public CollectInfo(InstancedConfiguration alluxioConf) {
        super(CMD_ALIAS, UNSTABLE_ALIAS, alluxioConf);
    }

    public Set<String> getHosts() {
        String confDirPath = this.mConfiguration.getString(PropertyKey.CONF_DIR);
        System.out.format("Looking for masters and workers in %s%n", confDirPath);
        Set hosts = ConfigurationUtils.getServerHostnames((AlluxioConfiguration)this.mConfiguration);
        System.out.format("Found %s hosts%n", hosts.size());
        return hosts;
    }

    public static void printHelp(String message) {
        System.err.println(message);
        HelpFormatter help = new HelpFormatter();
        help.setWidth(200);
        help.printHelp(USAGE, OPTIONS);
    }

    public static void main(String[] argv) throws IOException {
        int ret;
        CommandLine cmd;
        DefaultParser parser = new DefaultParser();
        try {
            cmd = parser.parse(OPTIONS, argv, true);
        }
        catch (ParseException e) {
            return;
        }
        String[] args = cmd.getArgs();
        if (cmd.hasOption(HELP_OPTION_NAME)) {
            CollectInfo.printHelp("");
            System.exit(0);
        }
        InstancedConfiguration conf = new InstancedConfiguration(ConfigurationUtils.defaults());
        conf.set(PropertyKey.USER_RPC_RETRY_MAX_DURATION, (Object)"5s", Source.DEFAULT);
        CollectInfo shell = new CollectInfo(conf);
        if (args.length < 2) {
            CollectInfo.printHelp(String.format("Command requires at least %s arguments (%s provided)%n", 2, argv.length));
            System.exit(-1);
        }
        if (cmd.hasOption(LOCAL_OPTION_NAME)) {
            System.out.println("Executing collectInfo locally");
            ret = shell.collectInfoLocal(cmd);
        } else {
            System.out.println("Executing collectInfo on all nodes in the cluster");
            ret = shell.collectInfoRemote(cmd);
        }
        shell.close();
        System.exit(ret);
    }

    private List<String> cmdLineToArgs(CommandLine cmd) {
        ArrayList<String> args = new ArrayList<String>();
        for (Option opt : cmd.getOptions()) {
            if (opt.equals((Object)LOCAL_OPTION) || opt.equals((Object)THREAD_NUM_OPTION)) continue;
            args.add("--" + opt.getLongOpt());
            if (!opt.hasArg()) continue;
            args.add(opt.getValue());
        }
        args.addAll(cmd.getArgList());
        return args;
    }

    private int collectInfoRemote(CommandLine cmdLine) throws IOException {
        int ret = 0;
        String[] args = cmdLine.getArgs();
        String targetDir = args[1];
        ArrayList<String> allHosts = new ArrayList<String>(this.getHosts());
        System.out.format("Init thread pool for %s hosts%n", allHosts.size());
        int threadNum = allHosts.size();
        if (cmdLine.hasOption("threads")) {
            int maxThreadNum = Integer.parseInt(cmdLine.getOptionValue(MAX_THREAD_OPTION_NAME));
            LOG.info("Max thread number is {}", (Object)maxThreadNum);
            threadNum = Math.min(maxThreadNum, threadNum);
        }
        LOG.info("Use {} threads", (Object)threadNum);
        this.mExecutor = Executors.newFixedThreadPool(threadNum);
        ArrayList<CompletableFuture<CommandReturn>> sshFutureList = new ArrayList<CompletableFuture<CommandReturn>>();
        for (String host : allHosts) {
            System.out.format("Execute collectInfo on host %s%n", host);
            CompletableFuture<CommandReturn> future = CompletableFuture.supplyAsync(() -> {
                String workDir = this.mConfiguration.getString(PropertyKey.WORK_DIR);
                String alluxioBinPath = Paths.get(workDir, "bin/alluxio").toAbsolutePath().toString();
                System.out.format("host: %s, alluxio path %s%n", host, alluxioBinPath);
                Object[] collectInfoArgs = (String[])ArrayUtils.addAll((Object[])new String[]{alluxioBinPath, "collectInfo", "--local"}, (Object[])this.cmdLineToArgs(cmdLine).toArray(new String[0]));
                System.out.format("Invoking command %s%n", Arrays.toString(collectInfoArgs));
                try {
                    CommandReturn cr = ShellUtils.sshExecCommandWithOutput((String)host, (String[])collectInfoArgs);
                    return cr;
                }
                catch (Exception e) {
                    LOG.error("Execution failed %s", (Throwable)e);
                    return new CommandReturn(1, (String[])collectInfoArgs, e.toString());
                }
            }, this.mExecutor);
            sshFutureList.add(future);
            System.out.format("Invoked local collectInfo command on host %s%n", host);
        }
        List<String> sshSucceededHosts = this.collectCommandReturnsFromHosts(sshFutureList, allHosts);
        if (sshSucceededHosts.size() == 0) {
            System.err.println("Failed to invoke local collectInfo command on all hosts!");
            return 1;
        }
        File tempDir = Files.createTempDir();
        ArrayList<File> filesFromHosts = new ArrayList<File>();
        ArrayList<CompletableFuture<CommandReturn>> scpFutures = new ArrayList<CompletableFuture<CommandReturn>>(allHosts.size());
        for (String host : sshSucceededHosts) {
            File tarballFromHost = new File(tempDir, host);
            tarballFromHost.mkdir();
            filesFromHosts.add(tarballFromHost);
            CompletableFuture<CommandReturn> future = CompletableFuture.supplyAsync(() -> {
                System.out.format("Collecting tarball from host %s%n", host);
                String fromPath = Paths.get(targetDir, TARBALL_NAME).toAbsolutePath().toString();
                String toPath = tarballFromHost.getAbsolutePath();
                LOG.debug("Copying {}:{} to {}", new Object[]{host, fromPath, toPath});
                try {
                    CommandReturn cr = ShellUtils.scpCommandWithOutput((String)host, (String)fromPath, (String)toPath, (boolean)false);
                    return cr;
                }
                catch (IOException e) {
                    LOG.error("Execution failed", (Throwable)e);
                    return new CommandReturn(1, e.toString());
                }
            }, this.mExecutor);
            scpFutures.add(future);
        }
        List<String> scpSucceededHosts = this.collectCommandReturnsFromHosts(scpFutures, sshSucceededHosts);
        System.out.format("Tarballs of %d/%d hosts copied%n", scpSucceededHosts.size(), allHosts.size());
        if (scpSucceededHosts.size() == 0) {
            System.err.println("Failed to collect tarballs from all hosts!");
            return 2;
        }
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss");
        String finalTarballpath = Paths.get(targetDir, String.format(FINAL_TARBALL_NAME, dtf.format(LocalDateTime.now()))).toAbsolutePath().toString();
        TarUtils.compress(finalTarballpath, filesFromHosts.toArray(new File[0]));
        System.out.println("Final tarball compressed to " + finalTarballpath);
        try {
            FileUtils.delete((String)tempDir.getPath());
        }
        catch (IOException e) {
            LOG.warn("Failed to delete temp dir {}", (Object)tempDir.toString());
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    private int collectInfoLocal(CommandLine cmdLine) throws IOException {
        ret = 0;
        args = cmdLine.getArgs();
        subCommand = args[0];
        targetDirPath = args[1];
        filesToCollect = new ArrayList<File>();
        if (subCommand.equals("all")) {
            System.out.println("Execute all child commands");
            childArgs = Arrays.copyOf(args, args.length);
            for (Command cmd : this.getCommands()) {
                System.out.format("Executing %s%n", new Object[]{cmd.getCommandName()});
                childArgs[0] = cmd.getCommandName();
                try {
                    childRet = this.executeAndAddFile(childArgs, cmdLine, filesToCollect);
                    if (ret != 0 || childRet == 0) continue;
                    System.err.format("Command %s failed%n", new Object[]{cmd.getCommandName()});
                    ret = childRet;
                }
                catch (AlluxioException e) {
                    System.err.format("Command %s failed with exception:%n", new Object[]{cmd.getCommandName()});
                    e.printStackTrace(System.err);
                }
            }
        } else {
            try {
                childRet = this.executeAndAddFile(args, cmdLine, filesToCollect);
                if (childRet == 0) ** GOTO lbl36
                ret = childRet;
            }
            catch (AlluxioException e) {
                System.err.format("Command failed with exception:%n", new Object[0]);
                e.printStackTrace(System.err);
                return 1;
            }
        }
lbl36:
        // 3 sources

        System.out.format("Files to collect: %s%n", new Object[]{filesToCollect});
        System.out.format("Archiving dir %s%n", new Object[]{targetDirPath});
        tarballPath = Paths.get(targetDirPath, new String[]{"alluxio-info.tar.gz"}).toAbsolutePath().toString();
        if (filesToCollect.size() == 0) {
            System.err.format("No files to add. Tarball %s will be empty!%n", new Object[]{tarballPath});
            return 2;
        }
        TarUtils.compress(tarballPath, filesToCollect.toArray(new File[0]));
        System.out.println("Archiving finished");
        return ret;
    }

    private int executeAndAddFile(String[] argv, CommandLine cmdLine, List<File> filesToCollect) throws IOException, AlluxioException {
        String subCommand = argv[0];
        String targetDirPath = argv[1];
        System.out.format("subcommand %s targetDir %s%n", subCommand, targetDirPath);
        AbstractCollectInfoCommand cmd = this.findCommand(subCommand);
        if (cmd == null) {
            CollectInfo.printHelp(String.format("%s is an unknown command.%n", subCommand));
            return 1;
        }
        int ret = cmd.run(cmdLine);
        File infoCmdOutputFile = cmd.generateOutputFile(targetDirPath, cmd.getCommandName());
        filesToCollect.add(infoCmdOutputFile);
        return ret;
    }

    private AbstractCollectInfoCommand findCommand(String cmdName) {
        for (Command c : this.getCommands()) {
            if (!c.getCommandName().equals(cmdName)) continue;
            return (AbstractCollectInfoCommand)c;
        }
        return null;
    }

    private List<String> collectCommandReturnsFromHosts(List<CompletableFuture<CommandReturn>> futureList, List<String> hosts) {
        List results;
        try {
            results = CollectInfo.collectAllFutures(futureList).get();
            System.out.format("Results collected from %d hosts%n", results.size());
        }
        catch (InterruptedException | ExecutionException e) {
            System.err.format("Failed to collect the results. Error is %s%n", e.getMessage());
            LOG.error("Error: %s", (Throwable)e);
            return Collections.EMPTY_LIST;
        }
        if (results.size() != hosts.size()) {
            System.out.format("Error occurred while collecting information on %d/%d hosts%n", hosts.size() - results.size());
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> successfulHosts = new ArrayList<String>();
        for (int i = 0; i < hosts.size(); ++i) {
            CommandReturn c = (CommandReturn)results.get(i);
            String host = hosts.get(i);
            if (c.getExitCode() != 0) {
                System.out.format("Execution failed on host %s%n", host);
                System.out.println(c.getFormattedOutput());
                continue;
            }
            successfulHosts.add(host);
        }
        System.out.format("Command executed successfully on %d/%d hosts.", successfulHosts.size(), hosts.size());
        return successfulHosts;
    }

    public static <T> CompletableFuture<List<T>> collectAllFutures(List<CompletableFuture<T>> futures) {
        CompletableFuture[] cfs = futures.toArray(new CompletableFuture[futures.size()]);
        return CompletableFuture.allOf(cfs).thenApply(f -> futures.stream().map(CompletableFuture::join).collect(Collectors.toList()));
    }

    protected String getShellName() {
        return "collectInfo";
    }

    protected Map<String, Command> loadCommands() {
        return CommandUtils.loadCommands((String)CollectInfo.class.getPackage().getName(), (Class[])new Class[]{FileSystemContext.class}, (Object[])new Object[]{FileSystemContext.create((AlluxioConfiguration)this.mConfiguration)});
    }

    public void close() throws IOException {
        super.close();
        if (this.mExecutor != null && !this.mExecutor.isShutdown()) {
            this.mExecutor.shutdownNow();
        }
    }
}

