/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli;

import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

@ThreadSafe
public final class Version {
    private static final Option REVISION_OPT = Option.builder((String)"r").longOpt("revision").desc("Prints the git revision along with the Alluxio version. Optionally specify the revision length").optionalArg(true).argName("revision_length").hasArg(true).build();

    private Version() {
    }

    public static void main(String[] args) {
        DefaultParser parser = new DefaultParser();
        Options opts = new Options().addOption(REVISION_OPT);
        try {
            CommandLine cl = parser.parse(opts, args);
            String revision = "";
            if (cl.hasOption(REVISION_OPT.getOpt())) {
                String r = cl.getOptionValue(REVISION_OPT.getOpt());
                int revisionLen = r == null ? "de16f145bc9b43725538e4f83439460fc33202e2".length() : Integer.parseInt(r);
                revision = String.format("-%s", "de16f145bc9b43725538e4f83439460fc33202e2".substring(0, Math.min(revisionLen, "de16f145bc9b43725538e4f83439460fc33202e2".length())));
            }
            System.out.println(String.format("%s%s", "2.8.0-2", revision));
            System.exit(0);
        }
        catch (ParseException e) {
            Version.printUsage(opts);
        }
        catch (NumberFormatException e) {
            System.out.println(String.format("Couldn't parse <%s> as an integer", REVISION_OPT.getValue()));
            Version.printUsage(opts);
        }
        System.exit(1);
    }

    public static void printUsage(Options options) {
        new HelpFormatter().printHelp("version", options);
    }
}

