/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli;

import alluxio.cli.ValidationResults;
import alluxio.cli.ValidationTool;
import alluxio.cli.ValidationToolRegistry;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.Source;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.util.ConfigurationUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateHdfsMount {
    private static final Logger LOG = LoggerFactory.getLogger(ValidateHdfsMount.class);
    private static final String USAGE = "USAGE: runHdfsMountTests [--readonly] [--shared] [--option <key=val>] <hdfsURI>runHdfsMountTests runs a set of validations against the given hdfs path.";
    private static final Option READONLY_OPTION = Option.builder().longOpt("readonly").required(false).hasArg(false).desc("mount point is readonly in Alluxio").build();
    private static final Option SHARED_OPTION = Option.builder().longOpt("shared").required(false).hasArg(false).desc("mount point is shared").build();
    private static final Option HELP_OPTION = Option.builder().longOpt("help").required(false).hasArg(false).desc("show help").build();
    private static final Option OPTION_OPTION = Option.builder().longOpt("option").required(false).hasArg(true).numberOfArgs(2).argName("key=value").valueSeparator('=').desc("options associated with this mount point").build();
    private static final Options OPTIONS = new Options().addOption(READONLY_OPTION).addOption(SHARED_OPTION).addOption(HELP_OPTION).addOption(OPTION_OPTION);

    public static void printHelp(String message) {
        System.err.println(message);
        HelpFormatter help = new HelpFormatter();
        help.printHelp(USAGE, OPTIONS);
    }

    public static void main(String[] args) throws Exception {
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(OPTIONS, args, true);
        }
        catch (ParseException e) {
            ValidateHdfsMount.printHelp(String.format("Failed to parse arguments %s%n", Arrays.toString(args)));
            System.exit(1);
        }
        if (cmd.hasOption(HELP_OPTION.getLongOpt())) {
            ValidateHdfsMount.printHelp("Showing usage for the command");
            System.exit(0);
        }
        if ((args = cmd.getArgs()).length < 1) {
            ValidateHdfsMount.printHelp("Need at least 1 argument for <hdfsURI>!");
            System.exit(1);
        }
        String ufsPath = args[0];
        InstancedConfiguration conf = InstancedConfiguration.defaults();
        UnderFileSystemConfiguration ufsConf = UnderFileSystemConfiguration.defaults((AlluxioConfiguration)conf);
        if (cmd.hasOption(READONLY_OPTION.getLongOpt())) {
            ufsConf.setReadOnly(true);
        }
        if (cmd.hasOption(SHARED_OPTION.getLongOpt())) {
            ufsConf.setShared(true);
        }
        if (cmd.hasOption(OPTION_OPTION.getLongOpt())) {
            Properties properties = cmd.getOptionProperties(OPTION_OPTION.getLongOpt());
            ufsConf.merge((Map)properties, Source.MOUNT_OPTION);
            LOG.debug("Options from cmdline: {}", (Object)properties);
        }
        ValidationToolRegistry registry = new ValidationToolRegistry((AlluxioConfiguration)new InstancedConfiguration(ConfigurationUtils.defaults()));
        registry.refresh();
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("ufsPath", ufsPath);
        configMap.put("ufsConfig", (String)ufsConf);
        ValidationTool tests = registry.create("hdfs", configMap);
        String result = ValidationTool.toJson((ValidationResults)ValidationTool.convertResults((List)tests.runAllTests()));
        System.out.println(result);
        System.exit(0);
    }
}

