/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli;

import alluxio.ClientContext;
import alluxio.client.file.FileSystemContext;
import alluxio.client.job.JobMasterClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.job.wire.JobWorkerHealth;
import alluxio.util.ConfigurationUtils;
import alluxio.util.network.HttpUtils;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.wire.LogInfo;
import alluxio.wire.WorkerNetAddress;
import alluxio.worker.job.JobMasterClientContext;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Objects;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class LogLevel {
    private static final Logger LOG = LoggerFactory.getLogger(LogLevel.class);
    public static final String LOG_LEVEL = "logLevel";
    public static final String ROLE_WORKERS = "workers";
    public static final String ROLE_MASTER = "master";
    public static final String ROLE_MASTERS = "masters";
    public static final String ROLE_WORKER = "worker";
    public static final String ROLE_JOB_MASTER = "job_master";
    public static final String ROLE_JOB_MASTERS = "job_masters";
    public static final String ROLE_JOB_WORKER = "job_worker";
    public static final String ROLE_JOB_WORKERS = "job_workers";
    public static final String TARGET_SEPARATOR = ",";
    public static final String TARGET_OPTION_NAME = "target";
    private static final Option TARGET_OPTION = Option.builder().required(false).longOpt("target").hasArg(true).desc("<master|workers|job_master|job_workers|host:webPort>. A list of targets separated by , can be specified. host:webPort pair must be one of workers. Default target is master, job master, all workers and all job workers.").build();
    private static final String LOG_NAME_OPTION_NAME = "logName";
    private static final Option LOG_NAME_OPTION = Option.builder().required(true).longOpt("logName").hasArg(true).desc("The logger's name(e.g. alluxio.master.file.DefaultFileSystemMaster) you want to get or set level.").build();
    private static final String LEVEL_OPTION_NAME = "level";
    private static final Option LEVEL_OPTION = Option.builder().required(false).longOpt("level").hasArg(true).desc("The log level to be set.").build();
    private static final Options OPTIONS = new Options().addOption(TARGET_OPTION).addOption(LOG_NAME_OPTION).addOption(LEVEL_OPTION);

    public static void printHelp(String message) {
        System.err.println(message);
        HelpFormatter help = new HelpFormatter();
        help.printHelp(LOG_LEVEL, OPTIONS, true);
    }

    public static void logLevel(String[] args, AlluxioConfiguration alluxioConf) throws ParseException, IOException {
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(OPTIONS, args, true);
        List<TargetInfo> targets = LogLevel.parseOptTarget(cmd, alluxioConf);
        String logName = LogLevel.parseOptLogName(cmd);
        String level = LogLevel.parseOptLevel(cmd);
        for (TargetInfo targetInfo : targets) {
            LogLevel.setLogLevel(targetInfo, logName, level, alluxioConf);
        }
    }

    public static List<TargetInfo> parseOptTarget(CommandLine cmd, AlluxioConfiguration conf) throws IOException {
        String[] targets;
        if (cmd.hasOption(TARGET_OPTION_NAME)) {
            String argTarget = cmd.getOptionValue(TARGET_OPTION_NAME);
            if (StringUtils.isBlank((CharSequence)argTarget)) {
                throw new IOException("Option target can not be blank.");
            }
            targets = argTarget.contains(TARGET_SEPARATOR) ? argTarget.split(TARGET_SEPARATOR) : new String[]{argTarget};
        } else {
            targets = new String[]{ROLE_MASTER, ROLE_JOB_MASTER, ROLE_WORKERS, ROLE_JOB_WORKERS};
        }
        return LogLevel.getTargetInfos(targets, conf);
    }

    private static List<TargetInfo> getTargetInfos(String[] targets, AlluxioConfiguration conf) throws IOException {
        Set targetSet = Arrays.stream(targets).map(String::trim).collect(Collectors.toSet());
        ArrayList<TargetInfo> targetInfoList = new ArrayList<TargetInfo>();
        if (targetSet.contains(ROLE_MASTERS)) {
            System.out.println("The logLevel command will only take effect on the primary master, instead of on all the masters. ");
            targetSet.remove(ROLE_MASTERS);
            targetSet.add(ROLE_MASTER);
            System.out.println("Target `masters` is replaced with `master`.");
        }
        if (targetSet.contains(ROLE_JOB_MASTERS)) {
            System.out.println("The logLevel command will only take effect on the primary job master, instead of on all the masters. ");
            targetSet.remove(ROLE_JOB_MASTERS);
            targetSet.add(ROLE_JOB_MASTER);
            System.out.println("Target `job_masters` is replaced with `job_master`.");
        }
        ClientContext clientContext = ClientContext.create((AlluxioConfiguration)conf);
        FileSystemContext fsContext = null;
        JobMasterClient jobClient = null;
        for (String target : targetSet) {
            if (target.isEmpty()) continue;
            if (target.equals(ROLE_MASTER)) {
                if (fsContext == null) {
                    fsContext = FileSystemContext.create((ClientContext)clientContext);
                }
                String masterHost = fsContext.getMasterAddress().getHostName();
                int masterPort = NetworkAddressUtils.getPort((NetworkAddressUtils.ServiceAttributeProvider)NetworkAddressUtils.ServiceType.MASTER_WEB, (AlluxioConfiguration)conf);
                TargetInfo master = new TargetInfo(masterHost, masterPort, ROLE_MASTER);
                targetInfoList.add(master);
                continue;
            }
            if (target.equals(ROLE_JOB_MASTER)) {
                if (jobClient == null) {
                    jobClient = JobMasterClient.Factory.create((JobMasterClientContext)JobMasterClientContext.newBuilder((ClientContext)clientContext).build());
                }
                String jobMasterHost = jobClient.getAddress().getHostName();
                int jobMasterPort = NetworkAddressUtils.getPort((NetworkAddressUtils.ServiceAttributeProvider)NetworkAddressUtils.ServiceType.JOB_MASTER_WEB, (AlluxioConfiguration)conf);
                TargetInfo jobMaster = new TargetInfo(jobMasterHost, jobMasterPort, ROLE_JOB_MASTER);
                targetInfoList.add(jobMaster);
                continue;
            }
            if (target.equals(ROLE_WORKERS)) {
                List workerInfoList;
                if (fsContext == null) {
                    fsContext = FileSystemContext.create((ClientContext)ClientContext.create((AlluxioConfiguration)conf));
                }
                if ((workerInfoList = fsContext.getCachedWorkers()).size() == 0) {
                    System.out.println("No workers found");
                    System.exit(1);
                }
                for (Object workerInfo : workerInfoList) {
                    WorkerNetAddress netAddress = workerInfo.getNetAddress();
                    TargetInfo worker = new TargetInfo(netAddress.getHost(), netAddress.getWebPort(), ROLE_WORKER);
                    targetInfoList.add(worker);
                }
                continue;
            }
            if (target.equals(ROLE_JOB_WORKERS)) {
                List jobWorkerInfoList;
                Object workerInfo;
                if (jobClient == null) {
                    jobClient = JobMasterClient.Factory.create((JobMasterClientContext)JobMasterClientContext.newBuilder((ClientContext)clientContext).build());
                }
                if ((jobWorkerInfoList = jobClient.getAllWorkerHealth()).size() == 0) {
                    System.out.println("No job workers found");
                    System.exit(1);
                }
                int jobWorkerPort = conf.getInt(PropertyKey.JOB_WORKER_WEB_PORT);
                workerInfo = jobWorkerInfoList.iterator();
                while (workerInfo.hasNext()) {
                    JobWorkerHealth jobWorkerInfo = (JobWorkerHealth)workerInfo.next();
                    String jobWorkerHost = jobWorkerInfo.getHostname();
                    TargetInfo jobWorker = new TargetInfo(jobWorkerHost, jobWorkerPort, ROLE_JOB_WORKER);
                    targetInfoList.add(jobWorker);
                }
                continue;
            }
            if (target.contains(":")) {
                String[] hostPortPair = target.split(":");
                int port = Integer.parseInt(hostPortPair[1]);
                String role = LogLevel.inferRoleFromPort(port, conf);
                LOG.debug("Port {} maps to role {}", (Object)port, (Object)role);
                TargetInfo unspecifiedTarget = new TargetInfo(hostPortPair[0], port, role);
                System.out.format("Role inferred from port: %s%n", unspecifiedTarget);
                targetInfoList.add(unspecifiedTarget);
                continue;
            }
            throw new IOException(String.format("Unrecognized target argument: %s. Please pass the targets in the form of <host>:<port>, with comma as the separator.", target));
        }
        return targetInfoList;
    }

    private static String parseOptLogName(CommandLine cmd) {
        String argName = cmd.getOptionValue(LOG_NAME_OPTION_NAME);
        if (StringUtils.isNotBlank((CharSequence)argName)) {
            return argName;
        }
        return "";
    }

    private static String parseOptLevel(CommandLine cmd) {
        String argLevel;
        if (cmd.hasOption(LEVEL_OPTION_NAME) && StringUtils.isNotBlank((CharSequence)(argLevel = cmd.getOptionValue(LEVEL_OPTION_NAME)))) {
            return argLevel;
        }
        return null;
    }

    private static void setLogLevel(TargetInfo targetInfo, String logName, String level, AlluxioConfiguration alluxioConf) throws IOException {
        URIBuilder uriBuilder = new URIBuilder();
        uriBuilder.setScheme("http");
        uriBuilder.setHost(targetInfo.getHost());
        uriBuilder.setPort(targetInfo.getPort());
        uriBuilder.setPath("/api/v1/" + targetInfo.getRole() + "/" + LOG_LEVEL);
        uriBuilder.addParameter(LOG_NAME_OPTION_NAME, logName);
        if (level != null) {
            uriBuilder.addParameter(LEVEL_OPTION_NAME, level);
        }
        LOG.info("Setting log level on {}", (Object)uriBuilder.toString());
        HttpUtils.post((String)uriBuilder.toString(), (String)"", (Integer)5000, inputStream -> {
            ObjectMapper mapper = new ObjectMapper();
            LogInfo logInfo = (LogInfo)mapper.readValue(inputStream, LogInfo.class);
            System.out.println(targetInfo.toString() + logInfo.toString());
        });
    }

    private static String inferRoleFromPort(int port, AlluxioConfiguration conf) {
        if (port == NetworkAddressUtils.getPort((NetworkAddressUtils.ServiceAttributeProvider)NetworkAddressUtils.ServiceType.MASTER_WEB, (AlluxioConfiguration)conf)) {
            return ROLE_MASTER;
        }
        if (port == NetworkAddressUtils.getPort((NetworkAddressUtils.ServiceAttributeProvider)NetworkAddressUtils.ServiceType.WORKER_WEB, (AlluxioConfiguration)conf)) {
            return ROLE_WORKER;
        }
        if (port == NetworkAddressUtils.getPort((NetworkAddressUtils.ServiceAttributeProvider)NetworkAddressUtils.ServiceType.JOB_MASTER_WEB, (AlluxioConfiguration)conf)) {
            return ROLE_JOB_MASTER;
        }
        if (port == NetworkAddressUtils.getPort((NetworkAddressUtils.ServiceAttributeProvider)NetworkAddressUtils.ServiceType.JOB_WORKER_WEB, (AlluxioConfiguration)conf)) {
            return ROLE_JOB_WORKER;
        }
        throw new IllegalArgumentException(String.format("Unrecognized port in %s. Please make sure the port is in %s", port, Arrays.toString(new PropertyKey[]{PropertyKey.MASTER_WEB_PORT, PropertyKey.WORKER_WEB_PORT, PropertyKey.JOB_MASTER_WEB_PORT, PropertyKey.JOB_WORKER_WEB_PORT})));
    }

    public static void main(String[] args) {
        int exitCode = 1;
        try {
            LogLevel.logLevel(args, (AlluxioConfiguration)new InstancedConfiguration(ConfigurationUtils.defaults()));
            exitCode = 0;
        }
        catch (ParseException e) {
            LogLevel.printHelp("Unable to parse input args: " + e.getMessage());
        }
        catch (IOException e) {
            System.err.println("Failed to set log level:");
            e.printStackTrace();
        }
        System.exit(exitCode);
    }

    private LogLevel() {
    }

    public static final class TargetInfo {
        private String mRole;
        private String mHost;
        private int mPort;

        public TargetInfo(String host, int port, String role) {
            this.mHost = host;
            this.mPort = port;
            this.mRole = role;
        }

        public int getPort() {
            return this.mPort;
        }

        public String getHost() {
            return this.mHost;
        }

        public String getRole() {
            return this.mRole;
        }

        public String toString() {
            return this.mHost + ":" + this.mPort + "[" + this.mRole + "]";
        }

        public boolean equals(Object other) {
            if (!(other instanceof TargetInfo)) {
                return false;
            }
            TargetInfo otherTarget = (TargetInfo)other;
            return this.mRole.equals(otherTarget.mRole) && this.mHost.equals(otherTarget.mHost) && this.mPort == otherTarget.mPort;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.mRole, this.mHost, this.mPort});
        }
    }
}

