.TH FS 1
.SH NAME

fs \- command line interface for Alluxio provides users with basic file system operations

.SH SYNOPSIS

.B fs
[\fBcat\fR \fIpath\fR]

.B fs
[\fBchecksum\fR \fIpath\fR]

.B fs
[\fBchgrp\fR \fIgroup path\fR]

.B fs
[\fBchgrpr\fR \fIgroup path\fR]

.B fs
[\fBchmod\fR \fIpermission path\fR]

.B fs
[\fBchmodr\fR \fIpermission path\fR]

.B fs
[\fBchown\fR \fIowner path\fR]

.B fs
[\fBchownr\fR \fIowner path\fR]

.B fs
[\fBcopyFromLocal\fR \fIsourcePath remotePath\fR]

.B fs
[\fBcopyToLocal\fR \fIremotePath localPath\fR]

.B fs
[\fBcount\fR \fIpath\fR]

.B fs
[\fBcp \fR \fIsourcePath destinationPath\fR]

.B fs
[\fBdu\fR \fIpath\fR]

.B fs
[\fBfileInfo\fR \fIpath\fR]

.B fs
[\fBfree\fR \fIpath\fR]

.B fs
[\fBgetCapacityBytes\fR]

.B fs
[\fBgetUsedBytes\fR]

.B fs
[\fBload\fR \fIpath\fR]

.B fs
[\fBloadMetadata\fR \fIpath\fR]

.B fs
[\fBlocation\fR \fIpath\fR]

.B fs
[\fBls\fR \fIpath\fR]

.B fs
[\fBlsr\fR \fIpath\fR]

.B fs
[\fBmkdir\fR \fIpath\fR]

.B fs
[\fBmount\fR \fIpath  uri\fR]

.B fs
[\fBmv\fR \fIsource destination\fR]

.B fs
[\fBpersist\fR \fIpath\fR]

.B fs
[\fBpin\fR \fIpath\fR]

.B fs
[\fBreport\fR \fIpath\fR]

.B fs
[\fBrm\fR \fIpath\fR]

.B fs
[\fBrmr\fR \fIpath\fR]

.B fs
[\fBsetTtl\fR \fItime\fR]

.B fs
[\fBtail\fR \fIpath\fR]

.B fs
[\fBtouch\fR \fIpath\fR]

.B fs
[\fBunmount\fR \fIpath\fR]

.B fs
[\fBunpin\fR \fIpath\fR]

.B fs
[\fBunsetTtl\fR]

.SH DESCRIPTION

.B fs
command line interface for Alluxio provides users with basic file system operations.

.SH OPTIONS

.TP
.BR cat
\fIpath\fR
Print the content of the file to the console.

.TP
.BR checksum
\fIpath\fR
Calculate the md5 checksum for a file.

.TP
.BR chgrp
\fIgroup path\fR
Change the group of the directory or file.

.TP
.BR chgrpr
\fIgroup path\fR
Recursively change the group of the directory or file.

.TP
.BR chmod
\fIpermission path\fR
Change the permission of the directory or file.

.TP
.BR chmodr
\fIpermission path\fR
Recursively change the permission of the directory or file.

.TP
.BR chown
\fIowner path\fR
Change the owner of the directory or file.

.TP
.BR chownr
\fIowner path\fR
Recursively change the owner of the directory or file.

.TP
.BR copyFromLocal
\fIsourcePath remotePath\fR
Copy the specified file specified by "sourcePath" to the path specified by "remotePath". This
command will fail if remotePath already exists.

.TP
.BR copyToLocal
\fIremotePath localPath\fR
Copy the specified file from the path specified by "remotePath" to a local destination.

.TP
.BR count
\fIpath\fR
Display the number of folders and files matching the specified prefix in "path".

.TP
.BR cp
\fIsourcePath destinationPath\fR
Copy a file or directory within the Alluxio file system.

.TP
.BR du
\fIpath\fR
Display the size of a file or a directory specified by the input path.

.TP
.BR fileInfo
\fIpath\fR
Print the information of the blocks of a specified file.

.TP
.BR free
\fIpath\fR
Free a file or all files under a directory from Alluxio. If the file/directory is also in under
storage, it will still be available there.

.TP
.BR getCapacityBytes
Get the capacity of the Alluxio file system.

.TP
.BR getUsedBytes
Get number of bytes used in the Alluxio file system.

.TP
.BR load
\fIpath\fR
Load the data of a file or a directory from under storage into Alluxio.

.TP
.BR loadMetadata
\fIpath\fR
Load the metadata of a file or a directory from under storage into Alluxio.

.TP
.BR location
\fIpath\fR
Display a list of hosts that have the file data.

.TP
.BR ls
\fIpath\fR
List all the files and directories directly under the given path with information such as size.

.TP
.BR lsr
\fIpath\fR
Recursively list all the files and directories under the given path with information such as size.

.TP
.BR mkdir
\fIpath\fR
Create a directory under the given path, along with any necessary parent directories. This command
will fail if the given path already exists.

.TP
.BR mount
\fIpath uri\fR
Mount the underlying file system path "uri" into the Alluxio namespace as "path". The "path" is
assumed not to exist and is created by the operation. No data or metadata is loaded from under
storage into Alluxio. After a path is mounted, operations on objects under the mounted path are
mirror to the mounted under storage.

.TP
.BR mv
\fIsource destination\fR
Move a file or directory specified by "source" to a new location "destination". This command will
fail if "destination" already exists.

.TP
.BR persist
\fIpath\fR
Persist a file or directory currently stored only in Alluxio to the underlying file system.

.TP
.BR pin
\fIpath\fR
Pin the given file to avoid evicting it from memory. If the given path is a directory, it
recursively pins all the files contained and any new files created within this directory.

.TP
.BR report
\fIpath\fR
Report to the master that a file is lost.

.TP
.BR rm
\fIpath\fR
Remove a file. This command will fail if the given path is a directory rather than a file.

.TP
.BR rmr
\fIpath\fR
Remove a file, or a directory with all the files and sub-directories that this directory contains.

.TP
.BR setTtl
\fItime\fR
Set the TTL (time to live) in milliseconds for a file.

.TP
.BR tail
\fIpath\fR
Print the last 1KB of the specified file to the console.

.TP
.BR touch
\fIpath\fR
Create a 0-byte file at the specified location.

.TP
.BR unmount
\fIpath\fR
Unmount the underlying file system path mounted in the Alluxio namespace as "path". Alluxio objects
under "path" are removed from Alluxio, but they still exist in the previously mounted under storage.

.TP
.BR updateMount
\fIpath\fR
Update options for an existing mount point while keeping Alluxio metadata under the path.

.TP
.BR unpin
\fIpath\fR
Unpin the given file to allow Alluxio to evict this file again. If the given path is a directory, it
recursively unpins all files contained and any new files created within this directory.

.TP
.BR unsetTtl
Remove the TTL (time to live) setting from a file.
