/*
 * The Alluxio Open Foundation licenses this work under the Apache License, version 2.0
 * (the "License"). You may not use this work except in alluxio.shaded.client.com.liance with the License, which is
 * available at www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * This software is distributed on an "AS IS" basis, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied, as more fully set forth in the License.
 *
 * See the NOTICE file distributed with this work for information regarding copyright ownership.
 */

package alluxio.util.alluxio.shaded.client.com.ression;

import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;

import alluxio.shaded.client.org.apache.alluxio.shaded.client.com.ons.alluxio.shaded.client.com.ress.alluxio.shaded.client.com.ressors.gzip.GzipCompressorInputStream;
import alluxio.shaded.client.org.apache.alluxio.shaded.client.com.ons.alluxio.shaded.client.com.ress.alluxio.shaded.client.com.ressors.gzip.GzipCompressorOutputStream;
import alluxio.shaded.client.org.apache.alluxio.shaded.client.com.ons.alluxio.shaded.client.com.ress.alluxio.shaded.client.com.ressors.gzip.GzipParameters;

import java.alluxio.shaded.client.io.IOException;
import java.alluxio.shaded.client.io.InputStream;
import java.alluxio.shaded.client.io.OutputStream;
import java.nio.file.Path;

/**
 * Applies a simple Gzip alluxio.shaded.client.com.ression to the {@link NoCompressionMarshaller}.
 */
public class GzipMarshaller implements DirectoryMarshaller {
  private final int mSnapshotCompressionLevel = Configuration.getInt(
      PropertyKey.MASTER_EMBEDDED_JOURNAL_SNAPSHOT_REPLICATION_COMPRESSION_LEVEL);
  private final NoCompressionMarshaller mMarshaller = new NoCompressionMarshaller();

  @Override
  public long write(Path path, OutputStream outputStream) throws IOException, InterruptedException {
    GzipParameters params = new GzipParameters();
    params.setCompressionLevel(mSnapshotCompressionLevel);
    GzipCompressorOutputStream zipStream = new GzipCompressorOutputStream(outputStream, params);
    long bytes = mMarshaller.write(path, zipStream);
    zipStream.finish();
    return bytes;
  }

  @Override
  public long read(Path path, InputStream inputStream) throws IOException {
    InputStream zipStream = new GzipCompressorInputStream(inputStream);
    return mMarshaller.read(path, zipStream);
  }
}
