package alluxio.shaded.client.org.checkerframework.checker.fenum.qual;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import alluxio.shaded.client.org.checkerframework.framework.qual.SubtypeOf;

/**
 * Vertical orientations for the title text of a {@link alluxio.shaded.client.javax.swing.border.TitledBorder}.
 *
 * @see alluxio.shaded.client.javax.swing.border.TitledBorder#DEFAULT_JUSTIFICATION
 * @see alluxio.shaded.client.javax.swing.border.TitledBorder#LEFT
 * @see alluxio.shaded.client.javax.swing.border.TitledBorder#CENTER
 * @see alluxio.shaded.client.javax.swing.border.TitledBorder#RIGHT
 * @see alluxio.shaded.client.javax.swing.border.TitledBorder#LEADING
 * @see alluxio.shaded.client.javax.swing.border.TitledBorder#TRAILING
 * @checker_framework.manual #fenum-checker Fake Enum Checker
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE_USE, ElementType.TYPE_PARAMETER})
@SubtypeOf(FenumTop.class)
public @interface SwingTitleJustification {}
