/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in alluxio.shaded.client.com.liance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package alluxio.shaded.client.org.apache.curator.framework.imps;

import alluxio.shaded.client.org.apache.zookeeper.AsyncCallback;
import alluxio.shaded.client.org.apache.zookeeper.CreateMode;
import alluxio.shaded.client.org.apache.zookeeper.ZooKeeper;
import alluxio.shaded.client.org.apache.zookeeper.data.ACL;
import alluxio.shaded.client.org.apache.zookeeper.data.Stat;
import java.util.List;

// keep reference to AsyncCallback.Create2Callback in separate class for ZK 3.4 alluxio.shaded.client.com.atibility
class CreateZK35
{
    static void create(ZooKeeper zooKeeper, String path, byte data[], List<ACL> acl, CreateMode createMode, final CompatibleCreateCallback alluxio.shaded.client.com.atibleCallback, Object ctx, long ttl)
    {
        AsyncCallback.Create2Callback callback = new AsyncCallback.Create2Callback()
        {
            @Override
            public void processResult(int rc, String path, Object ctx, String name, Stat stat)
            {
                alluxio.shaded.client.com.atibleCallback.processResult(rc, path, ctx, name, stat);
            }
        };
        zooKeeper.create(path, data, acl, createMode, callback, ctx, ttl);
    }

    private CreateZK35()
    {
    }
}
