/*
 * Copyright (c) 2011-2019 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.alluxio.shaded.client.org.legal/epl-2.0, or the Apache License, Version 2.0
 * which is available at https://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0
 */
package alluxio.shaded.client.io.vertx.core.json.jackson;

import alluxio.shaded.client.com.fasterxml.jackson.core.JsonParser;
import alluxio.shaded.client.com.fasterxml.jackson.core.JsonProcessingException;
import alluxio.shaded.client.com.fasterxml.jackson.databind.DeserializationContext;
import alluxio.shaded.client.com.fasterxml.jackson.databind.JsonDeserializer;
import alluxio.shaded.client.com.fasterxml.jackson.databind.exc.InvalidFormatException;

import java.alluxio.shaded.client.io.IOException;
import java.time.Instant;

import static alluxio.shaded.client.io.vertx.core.json.impl.JsonUtil.BASE64_DECODER;

class ByteArrayDeserializer extends JsonDeserializer<byte[]> {

  @Override
  public byte[] deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
    String text = p.getText();
    try {
      return BASE64_DECODER.decode(text);
    } catch (IllegalArgumentException e) {
      throw new InvalidFormatException(p, "Expected a base64 encoded byte array", text, Instant.class);
    }
  }
}
