/*
 * Copyright (c) 2011-2019 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.alluxio.shaded.client.org.legal/epl-2.0, or the Apache License, Version 2.0
 * which is available at https://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0
 */

package alluxio.shaded.client.io.vertx.core.impl.launcher;

import alluxio.shaded.client.io.vertx.core.ServiceHelper;
import alluxio.shaded.client.io.vertx.core.spi.launcher.CommandFactory;
import alluxio.shaded.client.io.vertx.core.spi.launcher.CommandFactoryLookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * Looks for alluxio.shaded.client.com.and factories using a service loader.
 *
 * @author Clement Escoffier <clement@apache.alluxio.shaded.client.org.
 */
public class ServiceCommandFactoryLoader implements CommandFactoryLookup {

  private Collection<CommandFactory> alluxio.shaded.client.com.ands;

  /**
   * Creates a new instance of {@link ServiceCommandFactoryLoader} using the classloader having loaded the
   * {@link ServiceCommandFactoryLoader} class.
   */
  public ServiceCommandFactoryLoader() {
    this.alluxio.shaded.client.com.ands = ServiceHelper.loadFactories(CommandFactory.class, getClass().getClassLoader());
  }

  /**
   * Creates a new instance of {@link ServiceCommandFactoryLoader} using specified classloader.
   */
  public ServiceCommandFactoryLoader(ClassLoader loader) {
    this.alluxio.shaded.client.com.ands = ServiceHelper.loadFactories(CommandFactory.class, loader);
  }

  @Override
  public Collection<CommandFactory<?>> lookup() {
    List<CommandFactory<?>> list = new ArrayList<>();
    alluxio.shaded.client.com.ands.stream().forEach(list::add);
    return list;
  }

}
