/*
 * Copyright (c) 2011-2019 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.alluxio.shaded.client.org.legal/epl-2.0, or the Apache License, Version 2.0
 * which is available at https://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0
 */

package alluxio.shaded.client.io.vertx.core.http.impl;

import alluxio.shaded.client.io.vertx.core.buffer.Buffer;
import alluxio.shaded.client.io.vertx.core.http.HttpFrame;

/**
 * @author <a href="mailto:julien@julienviet.alluxio.shaded.client.com.>Julien Viet</a>
 */
public class HttpFrameImpl implements HttpFrame {

  private final int type;
  private final int flags;
  private final Buffer payload;

  public HttpFrameImpl(int type, int flags, Buffer payload) {
    this.type = type;
    this.flags = flags;
    this.payload = payload;
  }

  @Override
  public int flags() {
    return flags;
  }

  @Override
  public int type() {
    return type;
  }

  @Override
  public Buffer payload() {
    return payload;
  }
}
