/*
 * Copyright (c) 2011-2019 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.alluxio.shaded.client.org.legal/epl-2.0, or the Apache License, Version 2.0
 * which is available at https://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0
 */

package alluxio.shaded.client.io.vertx.core.datagram;

import alluxio.shaded.client.io.vertx.core.buffer.Buffer;
import alluxio.shaded.client.io.vertx.codegen.annotations.VertxGen;
import alluxio.shaded.client.io.vertx.core.net.SocketAddress;

/**
 * A received datagram packet (UDP) which contains the data and information about the sender of the data itself.
 *
 * @author <a href="mailto:nmaurer@redhat.alluxio.shaded.client.com.>Norman Maurer</a>
 */
@VertxGen
public interface DatagramPacket {

  /**
   * Returns the {@link alluxio.shaded.client.io.vertx.core.net.SocketAddress} of the sender that sent
   * this {@link alluxio.shaded.client.io.vertx.core.datagram.DatagramPacket}.
   *
   * @return the address of the sender
   */
  SocketAddress sender();

  /**
   * Returns the data of the {@link alluxio.shaded.client.io.vertx.core.datagram.DatagramPacket}
   *
   * @return the data
   */
  Buffer data();
}
