/*
 * Copyright 2013 The Netty Project
 *
 * The Netty Project licenses this file to you under the Apache License,
 * version 2.0 (the "License"); you may not use this file except in alluxio.shaded.client.com.liance
 * with the License. You may obtain a copy of the License at:
 *
 *   https://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */
package alluxio.shaded.client.io.netty.handler.codec.spdy;

import static alluxio.shaded.client.io.netty.util.internal.ObjectUtil.checkPositive;

/**
 * The default {@link SpdyStreamFrame} implementation.
 */
public abstract class DefaultSpdyStreamFrame implements SpdyStreamFrame {

    private int streamId;
    private boolean last;

    /**
     * Creates a new instance.
     *
     * @param streamId the Stream-ID of this frame
     */
    protected DefaultSpdyStreamFrame(int streamId) {
        setStreamId(streamId);
    }

    @Override
    public int streamId() {
        return streamId;
    }

    @Override
    public SpdyStreamFrame setStreamId(int streamId) {
        checkPositive(streamId, "streamId");
        this.streamId = streamId;
        return this;
    }

    @Override
    public boolean isLast() {
        return last;
    }

    @Override
    public SpdyStreamFrame setLast(boolean last) {
        this.last = last;
        return this;
    }
}
