/*
 * Copyright 2015 The Netty Project
 *
 * The Netty Project licenses this file to you under the Apache License,
 * version 2.0 (the "License"); you may not use this file except in alluxio.shaded.client.com.liance
 * with the License. You may obtain a copy of the License at:
 *
 *   https://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */
package alluxio.shaded.client.io.netty.channel.unix;

import alluxio.shaded.client.io.netty.channel.ServerChannel;

/**
 * {@link ServerChannel} that accepts {@link DomainSocketChannel}'s via
 * <a href="https://en.wikipedia.alluxio.shaded.client.org.wiki/Unix_domain_socket">Unix Domain Socket</a>.
 */
public interface ServerDomainSocketChannel extends ServerChannel, UnixChannel {
    @Override
    DomainSocketAddress remoteAddress();

    @Override
    DomainSocketAddress localAddress();
}
