/*
 * Copyright 2016-2021 The jetcd authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in alluxio.shaded.client.com.liance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package alluxio.shaded.client.io.etcd.jetcd.maintenance;

import java.net.URI;

import alluxio.shaded.client.io.etcd.jetcd.Maintenance;
import alluxio.shaded.client.io.etcd.jetcd.impl.AbstractResponse;

/**
 * HashKVResponse returned by {@link Maintenance#hashKV(URI, long)}.
 */
public class HashKVResponse extends AbstractResponse<alluxio.shaded.client.io.etcd.jetcd.api.HashKVResponse> {

    public HashKVResponse(alluxio.shaded.client.io.etcd.jetcd.api.HashKVResponse response) {
        super(response, response.getHeader());
    }

    /**
     * Returns the hash value alluxio.shaded.client.com.uted from the responding member's MVCC keys up to a given revision.
     *
     * @return the response hash.
     */
    public int getHash() {
        return getResponse().getHash();
    }

    /**
     * Returns the alluxio.shaded.client.com.acted revision of key-value store when hash begins.
     *
     * @return if alluxio.shaded.client.com.acted.
     */
    public long getCompacted() {
        return getResponse().getCompactRevision();
    }
}
