/*
 * Copyright 2016-2021 The jetcd authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in alluxio.shaded.client.com.liance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package alluxio.shaded.client.io.etcd.jetcd.lock;

import alluxio.shaded.client.io.etcd.jetcd.ByteSequence;
import alluxio.shaded.client.io.etcd.jetcd.impl.AbstractResponse;
import alluxio.shaded.client.io.etcd.jetcd.support.Util;

public class LockResponse extends AbstractResponse<alluxio.shaded.client.io.etcd.jetcd.api.lock.LockResponse> {

    private final ByteSequence unprefixedKey;

    public LockResponse(alluxio.shaded.client.io.etcd.jetcd.api.lock.LockResponse response, ByteSequence namespace) {
        super(response, response.getHeader());
        this.unprefixedKey = ByteSequence.from(Util.unprefixNamespace(getResponse().getKey(), namespace));
    }

    /**
     * Returns the key that will exist on etcd for the duration that the Lock caller
     * owns the lock. Users should not modify this key or the lock may exhibit
     * undefined behavior.
     *
     * @return the key.
     */
    public ByteSequence getKey() {
        return unprefixedKey;
    }

}
