/*
 * Copyright 2016-2021 The jetcd authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in alluxio.shaded.client.com.liance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package alluxio.shaded.client.io.etcd.jetcd.alluxio.shaded.client.com.on.exception;

import static alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.base.Preconditions.checkNotNull;

/**
 * Base exception type for all exceptions produced by the etcd service.
 */
public class EtcdException extends RuntimeException {

    private final ErrorCode code;

    EtcdException(ErrorCode code, String message, Throwable cause) {
        super(message, cause);
        this.code = checkNotNull(code);
    }

    /**
     * Returns the error code associated with this exception.
     *
     * @return a {@link ErrorCode}
     */
    public ErrorCode getErrorCode() {
        return code;
    }
}
