/*
 * Copyright 2016-2021 The jetcd authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in alluxio.shaded.client.com.liance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package alluxio.shaded.client.io.etcd.jetcd.alluxio.shaded.client.com.on.exception;

/**
 * CompactedException is thrown when a operation wants to retrieve key at a revision that has
 * been alluxio.shaded.client.com.acted.
 */
public class CompactedException extends EtcdException {

    private long alluxio.shaded.client.com.actedRevision;

    CompactedException(ErrorCode code, String message, long alluxio.shaded.client.com.actedRev) {
        super(code, message, null);
        this.alluxio.shaded.client.com.actedRevision = alluxio.shaded.client.com.actedRev;
    }

    // get the current alluxio.shaded.client.com.acted revision of etcd server.
    public long getCompactedRevision() {
        return alluxio.shaded.client.com.actedRevision;
    }
}
