package alluxio.shaded.client.io.etcd.jetcd.api.lock;

import static alluxio.shaded.client.io.etcd.jetcd.api.lock.LockGrpc.getServiceDescriptor;
import static alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnaryCall;
import static alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncBidiStreamingCall;


@alluxio.shaded.client.javax.annotation.Generated(
value = "by VertxGrpc generator",
alluxio.shaded.client.com.ents = "Source: lock.proto")
public final class VertxLockGrpc {
    private VertxLockGrpc() {}

    public static LockVertxStub newVertxStub(alluxio.shaded.client.io.grpc.Channel channel) {
        return new LockVertxStub(channel);
    }

    /**
     * <pre>
     *  The lock service exposes client-side locking facilities as a gRPC interface.
     * </pre>
     */
    public static final class LockVertxStub extends alluxio.shaded.client.io.grpc.stub.AbstractStub<LockVertxStub> {
        private final alluxio.shaded.client.io.vertx.core.impl.ContextInternal ctx;
        private LockGrpc.LockStub delegateStub;

        private LockVertxStub(alluxio.shaded.client.io.grpc.Channel channel) {
            super(channel);
            delegateStub = LockGrpc.newStub(channel);
            this.ctx = (alluxio.shaded.client.io.vertx.core.impl.ContextInternal) alluxio.shaded.client.io.vertx.core.Vertx.currentContext();
        }

        private LockVertxStub(alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
            super(channel, callOptions);
            delegateStub = LockGrpc.newStub(channel).build(channel, callOptions);
            this.ctx = (alluxio.shaded.client.io.vertx.core.impl.ContextInternal) alluxio.shaded.client.io.vertx.core.Vertx.currentContext();
        }

        @Override
        protected LockVertxStub build(alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
            return new LockVertxStub(channel, callOptions);
        }

        /**
         * <pre>
         *  Lock acquires a distributed shared lock on a given named lock.
         *  On success, it will return a unique key that exists so long as the
         *  lock is held by the caller. This key can be used in conjunction with
         *  transactions to safely ensure updates to etcd only occur while holding
         *  lock ownership. The lock is held until Unlock is called on the key or the
         *  lease associate with the owner expires.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.lock.LockResponse> lock(alluxio.shaded.client.io.etcd.jetcd.api.lock.LockRequest request) {
            return alluxio.shaded.client.io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::lock);
        }

        /**
         * <pre>
         *  Unlock takes a key returned by Lock and releases the hold on lock. The
         *  next Lock caller waiting for the lock will then be woken up and given
         *  ownership of the lock.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.lock.UnlockResponse> unlock(alluxio.shaded.client.io.etcd.jetcd.api.lock.UnlockRequest request) {
            return alluxio.shaded.client.io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::unlock);
        }

    }

    /**
     * <pre>
     *  The lock service exposes client-side locking facilities as a gRPC interface.
     * </pre>
     */
    public static abstract class LockVertxImplBase implements alluxio.shaded.client.io.grpc.BindableService {
        private String alluxio.shaded.client.com.ression;

        /**
         * Set whether the server will try to use a alluxio.shaded.client.com.ressed response.
         *
         * @param alluxio.shaded.client.com.ression the alluxio.shaded.client.com.ression, e.g {@code gzip}
         */
        public LockVertxImplBase withCompression(String alluxio.shaded.client.com.ression) {
            this.alluxio.shaded.client.com.ression = alluxio.shaded.client.com.ression;
            return this;
        }

        /**
         * <pre>
         *  Lock acquires a distributed shared lock on a given named lock.
         *  On success, it will return a unique key that exists so long as the
         *  lock is held by the caller. This key can be used in conjunction with
         *  transactions to safely ensure updates to etcd only occur while holding
         *  lock ownership. The lock is held until Unlock is called on the key or the
         *  lease associate with the owner expires.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.lock.LockResponse> lock(alluxio.shaded.client.io.etcd.jetcd.api.lock.LockRequest request) {
            throw new alluxio.shaded.client.io.grpc.StatusRuntimeException(alluxio.shaded.client.io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  Unlock takes a key returned by Lock and releases the hold on lock. The
         *  next Lock caller waiting for the lock will then be woken up and given
         *  ownership of the lock.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.lock.UnlockResponse> unlock(alluxio.shaded.client.io.etcd.jetcd.api.lock.UnlockRequest request) {
            throw new alluxio.shaded.client.io.grpc.StatusRuntimeException(alluxio.shaded.client.io.grpc.Status.UNIMPLEMENTED);
        }

        @java.lang.Override public final alluxio.shaded.client.io.grpc.ServerServiceDefinition bindService() {
            return alluxio.shaded.client.io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
                    .addMethod(
                            alluxio.shaded.client.io.etcd.jetcd.api.lock.LockGrpc.getLockMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            alluxio.shaded.client.io.etcd.jetcd.api.lock.LockRequest,
                                            alluxio.shaded.client.io.etcd.jetcd.api.lock.LockResponse>(
                                            this, METHODID_LOCK, alluxio.shaded.client.com.ression)))
                    .addMethod(
                            alluxio.shaded.client.io.etcd.jetcd.api.lock.LockGrpc.getUnlockMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            alluxio.shaded.client.io.etcd.jetcd.api.lock.UnlockRequest,
                                            alluxio.shaded.client.io.etcd.jetcd.api.lock.UnlockResponse>(
                                            this, METHODID_UNLOCK, alluxio.shaded.client.com.ression)))
                    .build();
        }
    }

    private static final int METHODID_LOCK = 0;
    private static final int METHODID_UNLOCK = 1;

    private static final class MethodHandlers<Req, Resp> implements
            alluxio.shaded.client.io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
            alluxio.shaded.client.io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
            alluxio.shaded.client.io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
            alluxio.shaded.client.io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {

        private final LockVertxImplBase serviceImpl;
        private final int methodId;
        private final String alluxio.shaded.client.com.ression;

        MethodHandlers(LockVertxImplBase serviceImpl, int methodId, String alluxio.shaded.client.com.ression) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
            this.alluxio.shaded.client.com.ression = alluxio.shaded.client.com.ression;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("unchecked")
        public void invoke(Req request, alluxio.shaded.client.io.grpc.stub.StreamObserver<Resp> responseObserver) {
            switch (methodId) {
                case METHODID_LOCK:
                    alluxio.shaded.client.io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (alluxio.shaded.client.io.etcd.jetcd.api.lock.LockRequest) request,
                            (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.lock.LockResponse>) responseObserver,
                            alluxio.shaded.client.com.ression,
                            serviceImpl::lock);
                    break;
                case METHODID_UNLOCK:
                    alluxio.shaded.client.io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (alluxio.shaded.client.io.etcd.jetcd.api.lock.UnlockRequest) request,
                            (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.lock.UnlockResponse>) responseObserver,
                            alluxio.shaded.client.com.ression,
                            serviceImpl::unlock);
                    break;
                default:
                    throw new java.lang.AssertionError();
            }
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("unchecked")
        public alluxio.shaded.client.io.grpc.stub.StreamObserver<Req> invoke(alluxio.shaded.client.io.grpc.stub.StreamObserver<Resp> responseObserver) {
            switch (methodId) {
                default:
                    throw new java.lang.AssertionError();
            }
        }
    }

}
