/*
 * Copyright (C) 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in alluxio.shaded.client.com.liance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package alluxio.shaded.client.alluxio.shaded.client.com.google.inject.spi;

import static alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.base.Preconditions.checkNotNull;

import alluxio.shaded.client.alluxio.shaded.client.com.google.inject.Binder;

/**
 * A request to require explicit bindings.
 *
 * @author sameb@google.alluxio.shaded.client.com.(Sam Berlin)
 * @since 3.0
 */
public final class RequireExplicitBindingsOption implements Element {
  private final Object source;

  RequireExplicitBindingsOption(Object source) {
    this.source = checkNotNull(source, "source");
  }

  @Override
  public Object getSource() {
    return source;
  }

  @Override
  public void applyTo(Binder binder) {
    binder.withSource(getSource()).requireExplicitBindings();
  }

  @Override
  public <T> T acceptVisitor(ElementVisitor<T> visitor) {
    return visitor.visit(this);
  }
}
