/*
 * Copyright 2010-2020 Amazon.alluxio.shaded.client.com. Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in alluxio.shaded.client.com.liance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.alluxio.shaded.client.com.apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package alluxio.shaded.client.com.amazonaws.http;

import alluxio.shaded.client.com.amazonaws.util.ValidationUtils;
import java.alluxio.shaded.client.io.File;
import alluxio.shaded.client.javax.net.ssl.KeyManager;
import alluxio.shaded.client.org.apache.alluxio.shaded.client.com.ons.logging.Log;
import alluxio.shaded.client.org.apache.alluxio.shaded.client.com.ons.logging.LogFactory;

/**
 * Implementation of {@link TlsKeyManagersProvider} that loads from a given file path.
 */
public final class FileStoreTlsKeyManagersProvider extends AbstractFileTlsKeyManagersProvider {
    private static final Log log = LogFactory.getLog(FileStoreTlsKeyManagersProvider.class);

    private final File storePath;
    private final String storeType;
    private final char[] password;

    public FileStoreTlsKeyManagersProvider(File storePath, String storeType, String password) {
        this.storePath = ValidationUtils.assertNotNull(storePath, "storePath");
        this.storeType = ValidationUtils.assertStringNotEmpty(storeType, "storeType");
        this.password = password != null ? password.toCharArray() : null;
    }

    @Override
    public KeyManager[] getKeyManagers() {
        try {
            return createKeyManagers(storePath, storeType, password);
        } catch (Exception e) {
            if (log.isWarnEnabled()) {
                log.warn(String.format("Unable to create KeyManagers from file %s", storePath.getAbsolutePath()), e);
            }
            return null;
        }
    }
}
