/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block;

import alluxio.exception.AlluxioException;
import alluxio.exception.BlockAlreadyExistsException;
import alluxio.exception.BlockDoesNotExistException;
import alluxio.exception.InvalidWorkerStateException;
import alluxio.exception.WorkerOutOfSpaceException;
import alluxio.grpc.AsyncCacheRequest;
import alluxio.grpc.Block;
import alluxio.grpc.BlockStatus;
import alluxio.grpc.CacheRequest;
import alluxio.grpc.GetConfigurationPOptions;
import alluxio.grpc.UfsReadOptions;
import alluxio.proto.dataserver.Protocol;
import alluxio.wire.Configuration;
import alluxio.wire.FileInfo;
import alluxio.wire.WorkerNetAddress;
import alluxio.worker.DataWorker;
import alluxio.worker.SessionCleanable;
import alluxio.worker.block.BlockHeartbeatReport;
import alluxio.worker.block.BlockStore;
import alluxio.worker.block.BlockStoreMeta;
import alluxio.worker.block.CreateBlockOptions;
import alluxio.worker.block.io.BlockReader;
import alluxio.worker.block.io.BlockWriter;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public interface BlockWorker
extends DataWorker,
SessionCleanable {
    public void abortBlock(long var1, long var3) throws IOException;

    public void commitBlock(long var1, long var3, boolean var5);

    public String createBlock(long var1, long var3, int var5, CreateBlockOptions var6);

    public BlockWriter createBlockWriter(long var1, long var3) throws IOException;

    public BlockHeartbeatReport getReport();

    public BlockStoreMeta getStoreMeta();

    public BlockStoreMeta getStoreMetaFull();

    public BlockReader createBlockReader(long var1, long var3, long var5, boolean var7, Protocol.OpenUfsBlockOptions var8) throws IOException;

    public BlockReader createUfsBlockReader(long var1, long var3, long var5, boolean var7, Protocol.OpenUfsBlockOptions var8) throws IOException;

    public void removeBlock(long var1, long var3) throws IOException;

    public void freeWorker() throws IOException;

    public void requestSpace(long var1, long var3, long var5);

    @Deprecated
    public void asyncCache(AsyncCacheRequest var1);

    public void cache(CacheRequest var1) throws AlluxioException, IOException;

    public CompletableFuture<List<BlockStatus>> load(List<Block> var1, UfsReadOptions var2);

    public void updatePinList(Set<Long> var1);

    public FileInfo getFileInfo(long var1) throws IOException;

    public void clearMetrics();

    public Configuration getConfiguration(GetConfigurationPOptions var1);

    public List<String> getWhiteList();

    public BlockStore getBlockStore();

    public WorkerNetAddress getWorkerAddress();

    public BlockReader readBlockRemote(long var1, long var3, long var5) throws BlockDoesNotExistException, InvalidWorkerStateException, IOException;

    public boolean openUfsBlock(long var1, long var3, Protocol.OpenUfsBlockOptions var5) throws BlockAlreadyExistsException;

    public void closeUfsBlock(long var1, long var3) throws BlockAlreadyExistsException, BlockDoesNotExistException, IOException, WorkerOutOfSpaceException;

    public void accessBlock(long var1, long var3) throws BlockDoesNotExistException;

    public void moveBlock(long var1, long var3, String var5) throws BlockDoesNotExistException, BlockAlreadyExistsException, InvalidWorkerStateException, WorkerOutOfSpaceException, IOException;

    public String readBlock(long var1, long var3, long var5) throws BlockDoesNotExistException, InvalidWorkerStateException;

    public void unlockBlock(long var1) throws BlockDoesNotExistException;

    public boolean unlockBlock(long var1, long var3);

    public long lockBlock(long var1, long var3) throws BlockDoesNotExistException;

    public long lockBlockNoException(long var1, long var3);

    public void createBlockRemote(long var1, long var3, String var5, long var6) throws BlockAlreadyExistsException, WorkerOutOfSpaceException, IOException;

    public BlockReader readUfsBlock(long var1, long var3, long var5) throws BlockDoesNotExistException, IOException;
}

