/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util;

import alluxio.shaded.client.com.google.common.hash.HashFunction;
import alluxio.shaded.client.com.google.common.hash.Hashing;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.shaded.client.org.apache.commons.codec.binary.Hex;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

@ThreadSafe
public class HashUtils {
    private static final HashFunction HASH_FUNCTION = Hashing.murmur3_32_fixed();

    private HashUtils() {
    }

    public static String hashAsStringMD5(String object) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(object.getBytes());
            return Hex.encodeHexString(md.digest()).toLowerCase();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return HASH_FUNCTION.hashString(object, StandardCharsets.UTF_8).toString();
        }
    }

    public static long hashAsLong(String object) {
        return HASH_FUNCTION.hashString(object, StandardCharsets.UTF_8).padToLong();
    }
}

