/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.vertx.grpc.stub;

import alluxio.shaded.client.io.grpc.Status;
import alluxio.shaded.client.io.grpc.stub.StreamObserver;
import alluxio.shaded.client.io.vertx.core.Future;
import alluxio.shaded.client.io.vertx.core.Handler;
import alluxio.shaded.client.io.vertx.core.Promise;
import alluxio.shaded.client.io.vertx.core.impl.ContextInternal;
import alluxio.shaded.client.io.vertx.core.streams.ReadStream;
import alluxio.shaded.client.io.vertx.core.streams.WriteStream;
import alluxio.shaded.client.io.vertx.grpc.stub.GrpcWriteStream;
import alluxio.shaded.client.io.vertx.grpc.stub.StreamObserverReadStream;
import java.util.function.BiConsumer;
import java.util.function.Function;

public final class ClientCalls {
    private ClientCalls() {
    }

    public static <I, O> Future<O> oneToOne(ContextInternal ctx, I request, BiConsumer<I, StreamObserver<O>> delegate) {
        Promise promise = ctx != null ? ctx.promise() : Promise.promise();
        delegate.accept(request, ClientCalls.toStreamObserver(promise));
        return promise.future();
    }

    public static <I, O> ReadStream<O> oneToMany(ContextInternal ctx, I request, BiConsumer<I, StreamObserver<O>> delegate) {
        StreamObserverReadStream response = new StreamObserverReadStream();
        delegate.accept(request, response);
        return response;
    }

    public static <I, O> Future<O> manyToOne(ContextInternal ctx, Handler<WriteStream<I>> requestHandler, Function<StreamObserver<O>, StreamObserver<I>> delegate) {
        Promise promise = ctx != null ? ctx.promise() : Promise.promise();
        StreamObserver<I> request = delegate.apply(ClientCalls.toStreamObserver(promise));
        requestHandler.handle(new GrpcWriteStream<I>(request));
        return promise.future();
    }

    public static <I, O> ReadStream<O> manyToMany(ContextInternal ctx, Handler<WriteStream<I>> requestHandler, Function<StreamObserver<O>, StreamObserver<I>> delegate) {
        StreamObserverReadStream response = new StreamObserverReadStream();
        StreamObserver<I> request = delegate.apply(response);
        requestHandler.handle(new GrpcWriteStream<I>(request));
        return response;
    }

    private static <O> StreamObserver<O> toStreamObserver(final Promise<O> promise) {
        return new StreamObserver<O>(){

            @Override
            public void onNext(O tResponse) {
                if (!promise.tryComplete(tResponse)) {
                    throw Status.INTERNAL.withDescription("More than one responses received for unary or client-streaming call").asRuntimeException();
                }
            }

            @Override
            public void onError(Throwable throwable) {
                promise.tryFail(throwable);
            }

            @Override
            public void onCompleted() {
            }
        };
    }
}

