/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.vertx.core.net.impl.pool;

import alluxio.shaded.client.io.vertx.core.AsyncResult;
import alluxio.shaded.client.io.vertx.core.Future;
import alluxio.shaded.client.io.vertx.core.Handler;
import alluxio.shaded.client.io.vertx.core.impl.ContextInternal;
import alluxio.shaded.client.io.vertx.core.impl.EventLoopContext;
import alluxio.shaded.client.io.vertx.core.impl.VertxInternal;
import alluxio.shaded.client.io.vertx.core.net.impl.pool.Lease;
import alluxio.shaded.client.io.vertx.core.net.impl.pool.PoolConnection;
import alluxio.shaded.client.io.vertx.core.net.impl.pool.PoolConnector;
import alluxio.shaded.client.io.vertx.core.net.impl.pool.PoolWaiter;
import alluxio.shaded.client.io.vertx.core.net.impl.pool.SimpleConnectionPool;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;

public interface ConnectionPool<C> {
    public static final Function<ContextInternal, EventLoopContext> EVENT_LOOP_CONTEXT_PROVIDER = ctx -> {
        if ((ctx = ctx.unwrap()) instanceof EventLoopContext) {
            return (EventLoopContext)ctx;
        }
        VertxInternal vertx = ctx.owner();
        return vertx.createEventLoopContext(ctx.nettyEventLoop(), ctx.workerPool(), ctx.classLoader());
    };

    public static <C> ConnectionPool<C> pool(PoolConnector<C> connector, int[] maxSizes) {
        return new SimpleConnectionPool<C>(connector, maxSizes);
    }

    public static <C> ConnectionPool<C> pool(PoolConnector<C> connector, int[] maxSizes, int maxWaiters) {
        return new SimpleConnectionPool<C>(connector, maxSizes, maxWaiters);
    }

    public ConnectionPool<C> connectionSelector(BiFunction<PoolWaiter<C>, List<PoolConnection<C>>, PoolConnection<C>> var1);

    public ConnectionPool<C> contextProvider(Function<ContextInternal, EventLoopContext> var1);

    public void acquire(ContextInternal var1, int var2, Handler<AsyncResult<Lease<C>>> var3);

    public void acquire(ContextInternal var1, PoolWaiter.Listener<C> var2, int var3, Handler<AsyncResult<Lease<C>>> var4);

    public void cancel(PoolWaiter<C> var1, Handler<AsyncResult<Boolean>> var2);

    public void evict(Predicate<C> var1, Handler<AsyncResult<List<C>>> var2);

    public void close(Handler<AsyncResult<List<Future<C>>>> var1);

    public int size();

    public int waiters();

    public int capacity();

    public int requests();
}

