/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.vertx.core.impl;

import alluxio.shaded.client.io.vertx.core.buffer.Buffer;
import alluxio.shaded.client.io.vertx.core.json.JsonArray;
import alluxio.shaded.client.io.vertx.core.json.JsonObject;
import alluxio.shaded.client.io.vertx.core.json.impl.JsonUtil;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ConversionHelper {
    public static Object toObject(Object obj) {
        if (obj instanceof Map) {
            return ConversionHelper.toJsonObject((Map)obj);
        }
        if (obj instanceof List) {
            return ConversionHelper.toJsonArray((List)obj);
        }
        if (obj instanceof CharSequence) {
            return obj.toString();
        }
        return obj;
    }

    private static Object toJsonElement(Object obj) {
        if (obj instanceof Map) {
            return ConversionHelper.toJsonObject((Map)obj);
        }
        if (obj instanceof List) {
            return ConversionHelper.toJsonArray((List)obj);
        }
        if (obj instanceof CharSequence) {
            return obj.toString();
        }
        if (obj instanceof Buffer) {
            return JsonUtil.BASE64_ENCODER.encodeToString(((Buffer)obj).getBytes());
        }
        return obj;
    }

    public static JsonObject toJsonObject(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        map = new LinkedHashMap<String, Object>(map);
        map.entrySet().forEach(e -> e.setValue(ConversionHelper.toJsonElement(e.getValue())));
        return new JsonObject(map);
    }

    public static JsonArray toJsonArray(List<Object> list) {
        if (list == null) {
            return null;
        }
        list = new ArrayList<Object>(list);
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, ConversionHelper.toJsonElement(list.get(i)));
        }
        return new JsonArray(list);
    }

    public static <T> T fromObject(Object obj) {
        if (obj instanceof JsonObject) {
            return (T)ConversionHelper.fromJsonObject((JsonObject)obj);
        }
        if (obj instanceof JsonArray) {
            return (T)ConversionHelper.fromJsonArray((JsonArray)obj);
        }
        if (obj instanceof Instant) {
            return (T)DateTimeFormatter.ISO_INSTANT.format((Instant)obj);
        }
        if (obj instanceof byte[]) {
            return (T)JsonUtil.BASE64_ENCODER.encodeToString((byte[])obj);
        }
        if (obj instanceof Enum) {
            return (T)((Enum)obj).name();
        }
        return (T)obj;
    }

    public static Map<String, Object> fromJsonObject(JsonObject json) {
        if (json == null) {
            return null;
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(json.getMap());
        map.entrySet().forEach(entry -> entry.setValue(ConversionHelper.fromObject(entry.getValue())));
        return map;
    }

    public static List<Object> fromJsonArray(JsonArray json) {
        if (json == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>(json.getList());
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, ConversionHelper.fromObject(list.get(i)));
        }
        return list;
    }
}

