/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.vertx.core.http.impl;

import alluxio.shaded.client.io.netty.buffer.ByteBuf;
import alluxio.shaded.client.io.netty.buffer.Unpooled;
import alluxio.shaded.client.io.vertx.core.AsyncResult;
import alluxio.shaded.client.io.vertx.core.Future;
import alluxio.shaded.client.io.vertx.core.Handler;
import alluxio.shaded.client.io.vertx.core.MultiMap;
import alluxio.shaded.client.io.vertx.core.buffer.Buffer;
import alluxio.shaded.client.io.vertx.core.http.HttpFrame;
import alluxio.shaded.client.io.vertx.core.http.HttpVersion;
import alluxio.shaded.client.io.vertx.core.http.StreamPriority;
import alluxio.shaded.client.io.vertx.core.http.impl.HttpClientConnection;
import alluxio.shaded.client.io.vertx.core.http.impl.HttpClientPush;
import alluxio.shaded.client.io.vertx.core.http.impl.HttpRequestHead;
import alluxio.shaded.client.io.vertx.core.http.impl.HttpResponseHead;
import alluxio.shaded.client.io.vertx.core.impl.ContextInternal;
import alluxio.shaded.client.io.vertx.core.impl.future.PromiseInternal;
import alluxio.shaded.client.io.vertx.core.streams.WriteStream;

public interface HttpClientStream
extends WriteStream<Buffer> {
    public int id();

    public Object metric();

    public HttpVersion version();

    public HttpClientConnection connection();

    public ContextInternal getContext();

    public void writeHead(HttpRequestHead var1, boolean var2, ByteBuf var3, boolean var4, StreamPriority var5, boolean var6, Handler<AsyncResult<Void>> var7);

    public void writeBuffer(ByteBuf var1, boolean var2, Handler<AsyncResult<Void>> var3);

    public void writeFrame(int var1, int var2, ByteBuf var3);

    public void continueHandler(Handler<Void> var1);

    public void pushHandler(Handler<HttpClientPush> var1);

    public void unknownFrameHandler(Handler<HttpFrame> var1);

    @Override
    default public Future<Void> write(Buffer data) {
        PromiseInternal<Void> promise = this.getContext().promise();
        this.writeBuffer(data.getByteBuf(), false, promise);
        return promise.future();
    }

    @Override
    default public void write(Buffer data, Handler<AsyncResult<Void>> handler) {
        this.writeBuffer(data.getByteBuf(), false, handler);
    }

    @Override
    default public Future<Void> end(Buffer data) {
        PromiseInternal<Void> promise = this.getContext().promise();
        this.writeBuffer(data.getByteBuf(), true, promise);
        return promise.future();
    }

    @Override
    default public void end(Buffer data, Handler<AsyncResult<Void>> handler) {
        this.writeBuffer(data.getByteBuf(), true, handler);
    }

    @Override
    default public Future<Void> end() {
        PromiseInternal<Void> promise = this.getContext().promise();
        this.writeBuffer(Unpooled.EMPTY_BUFFER, true, promise);
        return promise.future();
    }

    @Override
    default public void end(Handler<AsyncResult<Void>> handler) {
        this.writeBuffer(Unpooled.EMPTY_BUFFER, true, handler);
    }

    public void headHandler(Handler<HttpResponseHead> var1);

    public void chunkHandler(Handler<Buffer> var1);

    public void endHandler(Handler<MultiMap> var1);

    public void priorityHandler(Handler<StreamPriority> var1);

    public void closeHandler(Handler<Void> var1);

    public void doSetWriteQueueMaxSize(int var1);

    public boolean isNotWritable();

    public void doPause();

    public void doFetch(long var1);

    public void reset(Throwable var1);

    public StreamPriority priority();

    public void updatePriority(StreamPriority var1);
}

