/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.vertx.core.http.impl;

import alluxio.shaded.client.io.netty.handler.codec.http.HttpHeaderNames;
import alluxio.shaded.client.io.netty.handler.codec.http.HttpHeaderValues;
import alluxio.shaded.client.io.netty.handler.codec.http2.Http2Headers;
import alluxio.shaded.client.io.vertx.core.AsyncResult;
import alluxio.shaded.client.io.vertx.core.Handler;
import alluxio.shaded.client.io.vertx.core.MultiMap;
import alluxio.shaded.client.io.vertx.core.buffer.Buffer;
import alluxio.shaded.client.io.vertx.core.http.HttpClosedException;
import alluxio.shaded.client.io.vertx.core.http.HttpFrame;
import alluxio.shaded.client.io.vertx.core.http.HttpMethod;
import alluxio.shaded.client.io.vertx.core.http.HttpServerRequest;
import alluxio.shaded.client.io.vertx.core.http.StreamPriority;
import alluxio.shaded.client.io.vertx.core.http.impl.Http2ServerConnection;
import alluxio.shaded.client.io.vertx.core.http.impl.Http2ServerStreamHandler;
import alluxio.shaded.client.io.vertx.core.http.impl.VertxHttp2Stream;
import alluxio.shaded.client.io.vertx.core.impl.ContextInternal;
import alluxio.shaded.client.io.vertx.core.spi.metrics.HttpServerMetrics;
import alluxio.shaded.client.io.vertx.core.spi.metrics.Metrics;
import alluxio.shaded.client.io.vertx.core.spi.observability.HttpRequest;

class Http2ServerStream
extends VertxHttp2Stream<Http2ServerConnection> {
    protected final Http2Headers headers;
    protected final HttpMethod method;
    protected final String uri;
    protected final String host;
    private Object metric;
    private boolean requestEnded;
    private boolean responseEnded;
    Http2ServerStreamHandler request;

    Http2ServerStream(Http2ServerConnection conn, ContextInternal context, HttpMethod method, String uri) {
        super(conn, context);
        this.headers = null;
        this.method = method;
        this.uri = uri;
        this.host = null;
    }

    Http2ServerStream(Http2ServerConnection conn, ContextInternal context, Http2Headers headers, String serverOrigin) {
        super(conn, context);
        String host;
        String string = host = headers.get(":authority") != null ? ((CharSequence)headers.get(":authority")).toString() : null;
        if (host == null) {
            int idx = serverOrigin.indexOf("://");
            host = serverOrigin.substring(idx + 3);
        }
        this.headers = headers;
        this.host = host;
        this.uri = headers.get(":path") != null ? ((CharSequence)headers.get(":path")).toString() : null;
        this.method = headers.get(":method") != null ? HttpMethod.valueOf(((CharSequence)headers.get(":method")).toString()) : null;
    }

    void registerMetrics() {
        HttpServerMetrics metrics;
        if (Metrics.METRICS_ENABLED && (metrics = ((Http2ServerConnection)this.conn).metrics()) != null) {
            this.metric = this.request.response().isPush() ? metrics.responsePushed(((Http2ServerConnection)this.conn).metric(), this.method(), this.uri, this.request.response()) : metrics.requestBegin(((Http2ServerConnection)this.conn).metric(), (HttpRequest)((Object)this.request));
        }
    }

    @Override
    void onHeaders(Http2Headers headers, StreamPriority streamPriority) {
        if (streamPriority != null) {
            this.priority(streamPriority);
        }
        this.registerMetrics();
        CharSequence value = (CharSequence)headers.get(HttpHeaderNames.EXPECT);
        if (((Http2ServerConnection)this.conn).options.isHandle100ContinueAutomatically() && (value != null && HttpHeaderValues.CONTINUE.equals(value) || headers.contains(HttpHeaderNames.EXPECT, HttpHeaderValues.CONTINUE))) {
            this.request.response().writeContinue();
        }
        this.request.dispatch(((Http2ServerConnection)this.conn).requestHandler);
    }

    @Override
    void onEnd(MultiMap trailers) {
        HttpServerMetrics metrics;
        this.requestEnded = true;
        if (Metrics.METRICS_ENABLED && (metrics = ((Http2ServerConnection)this.conn).metrics()) != null) {
            metrics.requestEnd(this.metric, (HttpRequest)((Object)this.request), this.bytesRead());
        }
        super.onEnd(trailers);
    }

    @Override
    void doWriteHeaders(Http2Headers headers, boolean end, Handler<AsyncResult<Void>> handler) {
        HttpServerMetrics metrics;
        if (Metrics.METRICS_ENABLED && !end && (metrics = ((Http2ServerConnection)this.conn).metrics()) != null) {
            metrics.responseBegin(this.metric, this.request.response());
        }
        super.doWriteHeaders(headers, end, handler);
    }

    @Override
    void handleWritabilityChanged(boolean writable) {
        this.request.response().handlerWritabilityChanged(writable);
    }

    public HttpMethod method() {
        return this.method;
    }

    @Override
    protected void endWritten() {
        HttpServerMetrics metrics;
        this.responseEnded = true;
        if (Metrics.METRICS_ENABLED && (metrics = ((Http2ServerConnection)this.conn).metrics()) != null) {
            metrics.responseEnd(this.metric, this.request.response(), this.bytesWritten());
        }
    }

    @Override
    void handleClose(HttpClosedException ex) {
        HttpServerMetrics metrics;
        super.handleClose(ex);
        if (!(!Metrics.METRICS_ENABLED || (metrics = ((Http2ServerConnection)this.conn).metrics()) == null || this.requestEnded && this.responseEnded)) {
            metrics.requestReset(this.metric);
        }
        this.request.handleClose(ex);
    }

    @Override
    void handleReset(long errorCode) {
        this.request.handleReset(errorCode);
    }

    @Override
    void handleException(Throwable cause) {
        this.request.handleException(cause);
    }

    @Override
    void handleCustomFrame(HttpFrame frame) {
        this.request.handleCustomFrame(frame);
    }

    @Override
    void handlePriorityChange(StreamPriority newPriority) {
        this.request.handlePriorityChange(newPriority);
    }

    @Override
    void handleData(Buffer buf) {
        this.request.handleData(buf);
    }

    @Override
    void handleEnd(MultiMap trailers) {
        this.request.handleEnd(trailers);
    }

    @Override
    void onClose(HttpClosedException ex) {
        this.request.onClose(ex);
        super.onClose(ex);
    }

    public Object metric() {
        return this.metric;
    }

    public HttpServerRequest routed(String route) {
        HttpServerMetrics metrics;
        if (Metrics.METRICS_ENABLED && (metrics = ((Http2ServerConnection)this.conn).metrics()) != null && !this.responseEnded) {
            metrics.requestRouted(this.metric, route);
        }
        return null;
    }
}

