/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.vertx.core;

import alluxio.shaded.client.io.vertx.codegen.annotations.Fluent;
import alluxio.shaded.client.io.vertx.codegen.annotations.GenIgnore;
import alluxio.shaded.client.io.vertx.codegen.annotations.Nullable;
import alluxio.shaded.client.io.vertx.codegen.annotations.VertxGen;
import alluxio.shaded.client.io.vertx.core.AsyncResult;
import alluxio.shaded.client.io.vertx.core.Future;
import alluxio.shaded.client.io.vertx.core.Handler;
import alluxio.shaded.client.io.vertx.core.Promise;
import alluxio.shaded.client.io.vertx.core.Vertx;
import alluxio.shaded.client.io.vertx.core.impl.VertxThread;
import alluxio.shaded.client.io.vertx.core.impl.launcher.VertxCommandLauncher;
import alluxio.shaded.client.io.vertx.core.json.JsonObject;
import java.util.List;

@VertxGen
public interface Context {
    public static boolean isOnWorkerThread() {
        Thread t = Thread.currentThread();
        return t instanceof VertxThread && ((VertxThread)t).isWorker();
    }

    public static boolean isOnEventLoopThread() {
        Thread t = Thread.currentThread();
        return t instanceof VertxThread && !((VertxThread)t).isWorker();
    }

    public static boolean isOnVertxThread() {
        return Thread.currentThread() instanceof VertxThread;
    }

    public void runOnContext(Handler<Void> var1);

    public <T> void executeBlocking(Handler<Promise<T>> var1, boolean var2, Handler<AsyncResult<@Nullable T>> var3);

    default public <T> void executeBlocking(Handler<Promise<T>> blockingCodeHandler, Handler<AsyncResult<@Nullable T>> resultHandler) {
        this.executeBlocking(blockingCodeHandler, true, resultHandler);
    }

    public <T> Future<@Nullable T> executeBlocking(Handler<Promise<T>> var1, boolean var2);

    default public <T> Future<T> executeBlocking(Handler<Promise<T>> blockingCodeHandler) {
        return this.executeBlocking(blockingCodeHandler, true);
    }

    public String deploymentID();

    public @Nullable JsonObject config();

    default public List<String> processArgs() {
        return VertxCommandLauncher.getProcessArguments();
    }

    public boolean isEventLoopContext();

    public boolean isWorkerContext();

    public <T> T get(Object var1);

    public void put(Object var1, Object var2);

    public boolean remove(Object var1);

    public <T> T getLocal(Object var1);

    public void putLocal(Object var1, Object var2);

    public boolean removeLocal(Object var1);

    public Vertx owner();

    public int getInstanceCount();

    @Fluent
    public Context exceptionHandler(@Nullable Handler<Throwable> var1);

    @GenIgnore
    public @Nullable Handler<Throwable> exceptionHandler();
}

