/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.etcd.jetcd.impl;

import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.io.etcd.jetcd.ByteSequence;
import alluxio.shaded.client.io.etcd.jetcd.Lock;
import alluxio.shaded.client.io.etcd.jetcd.api.lock.LockRequest;
import alluxio.shaded.client.io.etcd.jetcd.api.lock.LockResponse;
import alluxio.shaded.client.io.etcd.jetcd.api.lock.UnlockRequest;
import alluxio.shaded.client.io.etcd.jetcd.api.lock.VertxLockGrpc;
import alluxio.shaded.client.io.etcd.jetcd.impl.ClientConnectionManager;
import alluxio.shaded.client.io.etcd.jetcd.impl.Impl;
import alluxio.shaded.client.io.etcd.jetcd.lock.UnlockResponse;
import alluxio.shaded.client.io.etcd.jetcd.support.Errors;
import alluxio.shaded.client.io.etcd.jetcd.support.Util;
import java.util.concurrent.CompletableFuture;

final class LockImpl
extends Impl
implements Lock {
    private final VertxLockGrpc.LockVertxStub stub;
    private final ByteSequence namespace;

    LockImpl(ClientConnectionManager connectionManager) {
        super(connectionManager);
        this.stub = connectionManager.newStub(VertxLockGrpc::newVertxStub);
        this.namespace = connectionManager.getNamespace();
    }

    @Override
    public CompletableFuture<alluxio.shaded.client.io.etcd.jetcd.lock.LockResponse> lock(ByteSequence name, long leaseId) {
        Preconditions.checkNotNull(name);
        LockRequest request = LockRequest.newBuilder().setName(Util.prefixNamespace(name, this.namespace)).setLease(leaseId).build();
        return this.execute(() -> this.stub.lock(request), response -> new alluxio.shaded.client.io.etcd.jetcd.lock.LockResponse((LockResponse)response, this.namespace), Errors::isRetryable);
    }

    @Override
    public CompletableFuture<UnlockResponse> unlock(ByteSequence lockKey) {
        Preconditions.checkNotNull(lockKey);
        UnlockRequest request = UnlockRequest.newBuilder().setKey(Util.prefixNamespace(lockKey, this.namespace)).build();
        return this.execute(() -> this.stub.unlock(request), UnlockResponse::new, Errors::isRetryable);
    }
}

