/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.etcd.jetcd.impl;

import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.protobuf.ByteString;
import alluxio.shaded.client.io.etcd.jetcd.ByteSequence;
import alluxio.shaded.client.io.etcd.jetcd.Election;
import alluxio.shaded.client.io.etcd.jetcd.api.CampaignRequest;
import alluxio.shaded.client.io.etcd.jetcd.api.LeaderKey;
import alluxio.shaded.client.io.etcd.jetcd.api.LeaderRequest;
import alluxio.shaded.client.io.etcd.jetcd.api.LeaderResponse;
import alluxio.shaded.client.io.etcd.jetcd.api.ProclaimRequest;
import alluxio.shaded.client.io.etcd.jetcd.api.ResignRequest;
import alluxio.shaded.client.io.etcd.jetcd.api.VertxElectionGrpc;
import alluxio.shaded.client.io.etcd.jetcd.common.exception.EtcdExceptionFactory;
import alluxio.shaded.client.io.etcd.jetcd.election.CampaignResponse;
import alluxio.shaded.client.io.etcd.jetcd.election.NoLeaderException;
import alluxio.shaded.client.io.etcd.jetcd.election.NotLeaderException;
import alluxio.shaded.client.io.etcd.jetcd.election.ProclaimResponse;
import alluxio.shaded.client.io.etcd.jetcd.election.ResignResponse;
import alluxio.shaded.client.io.etcd.jetcd.impl.ClientConnectionManager;
import alluxio.shaded.client.io.etcd.jetcd.impl.Impl;
import alluxio.shaded.client.io.etcd.jetcd.support.Util;
import alluxio.shaded.client.io.grpc.StatusRuntimeException;
import java.util.concurrent.CompletableFuture;

final class ElectionImpl
extends Impl
implements Election {
    private final VertxElectionGrpc.ElectionVertxStub stub;
    private final ByteSequence namespace;

    ElectionImpl(ClientConnectionManager connectionManager) {
        super(connectionManager);
        this.stub = connectionManager.newStub(VertxElectionGrpc::newVertxStub);
        this.namespace = connectionManager.getNamespace();
    }

    @Override
    public CompletableFuture<CampaignResponse> campaign(ByteSequence electionName, long leaseId, ByteSequence proposal) {
        Preconditions.checkNotNull(electionName, "election name should not be null");
        Preconditions.checkNotNull(proposal, "proposal should not be null");
        CampaignRequest request = CampaignRequest.newBuilder().setName(Util.prefixNamespace(electionName, this.namespace)).setValue(ByteString.copyFrom(proposal.getBytes())).setLease(leaseId).build();
        return this.completable(this.stub.campaign(request), CampaignResponse::new, this::convertException);
    }

    @Override
    public CompletableFuture<ProclaimResponse> proclaim(alluxio.shaded.client.io.etcd.jetcd.election.LeaderKey leaderKey, ByteSequence proposal) {
        Preconditions.checkNotNull(leaderKey, "leader key should not be null");
        Preconditions.checkNotNull(proposal, "proposal should not be null");
        ProclaimRequest request = ProclaimRequest.newBuilder().setLeader(LeaderKey.newBuilder().setKey(ByteString.copyFrom(leaderKey.getKey().getBytes())).setName(ByteString.copyFrom(leaderKey.getName().getBytes())).setLease(leaderKey.getLease()).setRev(leaderKey.getRevision()).build()).setValue(ByteString.copyFrom(proposal.getBytes())).build();
        return this.completable(this.stub.proclaim(request), ProclaimResponse::new, this::convertException);
    }

    @Override
    public CompletableFuture<alluxio.shaded.client.io.etcd.jetcd.election.LeaderResponse> leader(ByteSequence electionName) {
        Preconditions.checkNotNull(electionName, "election name should not be null");
        LeaderRequest request = LeaderRequest.newBuilder().setName(Util.prefixNamespace(electionName, this.namespace)).build();
        return this.completable(this.stub.leader(request), r -> new alluxio.shaded.client.io.etcd.jetcd.election.LeaderResponse((LeaderResponse)r, this.namespace), this::convertException);
    }

    @Override
    public void observe(ByteSequence electionName, Election.Listener listener) {
        Preconditions.checkNotNull(electionName, "election name should not be null");
        Preconditions.checkNotNull(listener, "listener should not be null");
        LeaderRequest request = LeaderRequest.newBuilder().setName(ByteString.copyFrom(electionName.getBytes())).build();
        this.stub.observe(request).handler(value -> listener.onNext(new alluxio.shaded.client.io.etcd.jetcd.election.LeaderResponse((LeaderResponse)value, this.namespace))).endHandler(ignored -> listener.onCompleted()).exceptionHandler(error -> listener.onError(EtcdExceptionFactory.toEtcdException(error)));
    }

    @Override
    public CompletableFuture<ResignResponse> resign(alluxio.shaded.client.io.etcd.jetcd.election.LeaderKey leaderKey) {
        Preconditions.checkNotNull(leaderKey, "leader key should not be null");
        ResignRequest request = ResignRequest.newBuilder().setLeader(LeaderKey.newBuilder().setKey(ByteString.copyFrom(leaderKey.getKey().getBytes())).setName(ByteString.copyFrom(leaderKey.getName().getBytes())).setLease(leaderKey.getLease()).setRev(leaderKey.getRevision()).build()).build();
        return this.completable(this.stub.resign(request), ResignResponse::new, this::convertException);
    }

    private Throwable convertException(Throwable e) {
        if (e instanceof StatusRuntimeException) {
            StatusRuntimeException exception = (StatusRuntimeException)e;
            String description = exception.getStatus().getDescription();
            if ("election: not leader".equals(description)) {
                return new NotLeaderException();
            }
            if ("election: no leader".equals(description)) {
                return new NoLeaderException();
            }
        }
        return EtcdExceptionFactory.toEtcdException(e);
    }
}

