/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.com.rabbitmq.client;

import alluxio.shaded.client.com.rabbitmq.client.Address;
import alluxio.shaded.client.com.rabbitmq.client.AddressResolver;
import alluxio.shaded.client.javax.naming.NamingEnumeration;
import alluxio.shaded.client.javax.naming.NamingException;
import alluxio.shaded.client.javax.naming.directory.Attributes;
import alluxio.shaded.client.javax.naming.directory.InitialDirContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;

public class DnsSrvRecordAddressResolver
implements AddressResolver {
    private final String service;
    private final String dnsUrls;

    public DnsSrvRecordAddressResolver(String service) {
        this(service, "dns:");
    }

    public DnsSrvRecordAddressResolver(String service, String dnsUrls) {
        this.service = service;
        this.dnsUrls = dnsUrls;
    }

    @Override
    public List<Address> getAddresses() throws IOException {
        List<SrvRecord> records = this.lookupSrvRecords(this.service, this.dnsUrls);
        records = this.sort(records);
        ArrayList<Address> addresses = new ArrayList<Address>();
        for (SrvRecord record : records) {
            addresses.add(new Address(record.getHost(), record.getPort()));
        }
        return addresses;
    }

    protected List<SrvRecord> lookupSrvRecords(String service, String dnsUrls) throws IOException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        env.put("java.naming.provider.url", dnsUrls);
        ArrayList<SrvRecord> records = new ArrayList<SrvRecord>();
        try {
            InitialDirContext ctx = new InitialDirContext(env);
            Attributes attributes = ctx.getAttributes(service, new String[]{"SRV"});
            NamingEnumeration servers = attributes.get("srv").getAll();
            while (servers.hasMore()) {
                records.add(this.mapSrvRecord((String)servers.next()));
            }
        }
        catch (NamingException e) {
            throw new IOException("Error during DNS SRV query", e);
        }
        return records;
    }

    protected SrvRecord mapSrvRecord(String srvResult) {
        return SrvRecord.fromSrvQueryResult(srvResult);
    }

    protected List<SrvRecord> sort(List<SrvRecord> records) {
        Collections.sort(records);
        return records;
    }

    public static class SrvRecord
    implements Comparable<SrvRecord> {
        private final int priority;
        private final int weight;
        private final int port;
        private final String host;

        public SrvRecord(int priority, int weight, int port, String host) {
            this.priority = priority;
            this.weight = weight;
            this.port = port;
            int lastDotIndex = host.lastIndexOf(".");
            this.host = lastDotIndex > 0 ? host.substring(0, lastDotIndex) : host;
        }

        public int getPriority() {
            return this.priority;
        }

        public int getWeight() {
            return this.weight;
        }

        public int getPort() {
            return this.port;
        }

        public String getHost() {
            return this.host;
        }

        public static SrvRecord fromSrvQueryResult(String srvResult) {
            String[] fields = srvResult.split(" ");
            return new SrvRecord(Integer.parseInt(fields[0]), Integer.parseInt(fields[1]), Integer.parseInt(fields[2]), fields[3]);
        }

        @Override
        public int compareTo(SrvRecord o) {
            return this.priority < o.getPriority() ? -1 : (this.priority == o.getPriority() ? 0 : 1);
        }
    }
}

