/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.com.amazonaws.auth;

import alluxio.shaded.client.com.amazonaws.SdkClientException;
import alluxio.shaded.client.com.amazonaws.internal.SdkThreadLocalsRegistry;
import alluxio.shaded.client.javax.crypto.Mac;
import java.security.NoSuchAlgorithmException;

public enum SigningAlgorithm {
    HmacSHA1,
    HmacSHA256;

    private final ThreadLocal<Mac> macReference;

    private SigningAlgorithm() {
        final String algorithmName = this.toString();
        this.macReference = SdkThreadLocalsRegistry.register(new ThreadLocal<Mac>(){

            @Override
            protected Mac initialValue() {
                try {
                    return Mac.getInstance((String)algorithmName);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new SdkClientException("Unable to fetch Mac instance for Algorithm " + algorithmName + e.getMessage(), e);
                }
            }
        });
    }

    public Mac getMac() {
        return this.macReference.get();
    }
}

