/*
 * Decompiled with CFR 0.152.
 */
package alluxio.network.protocol.databuffer;

import alluxio.network.protocol.databuffer.DataBuffer;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;

public final class CompositeDataBuffer
implements DataBuffer {
    private final List<DataBuffer> mDataBufferList;

    public CompositeDataBuffer(List<DataBuffer> dataBufferList) {
        this.mDataBufferList = dataBufferList;
    }

    @Override
    public Object getNettyOutput() {
        return this.mDataBufferList;
    }

    @Override
    public long getLength() {
        long totalLength = 0L;
        for (DataBuffer dataBuffer : this.mDataBufferList) {
            totalLength += dataBuffer.getLength();
        }
        return totalLength;
    }

    @Override
    public ByteBuffer getReadOnlyByteBuffer() {
        throw new UnsupportedOperationException("DataFileChannel#getReadOnlyByteBuffer is not implemented.");
    }

    @Override
    public void readBytes(byte[] dst, int dstIndex, int length) {
        throw new UnsupportedOperationException("DataFileChannel#readBytes is not implemented.");
    }

    @Override
    public void readBytes(OutputStream outputStream, int length) throws IOException {
        throw new UnsupportedOperationException("DataFileChannel#readBytes is not implemented.");
    }

    @Override
    public void readBytes(ByteBuffer outputBuf) {
        throw new UnsupportedOperationException("DataFileChannel#readBytes is not implemented.");
    }

    @Override
    public int readableBytes() {
        long totalReadableByres = 0L;
        for (DataBuffer dataBuffer : this.mDataBufferList) {
            totalReadableByres += (long)dataBuffer.readableBytes();
        }
        return (int)totalReadableByres;
    }

    @Override
    public void release() {
        for (DataBuffer dataBuffer : this.mDataBufferList) {
            dataBuffer.release();
        }
    }
}

