/*
 * Decompiled with CFR 0.152.
 */
package alluxio.membership;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.membership.EtcdMembershipManager;
import alluxio.membership.MasterMembershipManager;
import alluxio.membership.MembershipType;
import alluxio.membership.ServiceRegistryMembershipManager;
import alluxio.membership.StaticMembershipManager;
import alluxio.membership.WorkerClusterView;
import alluxio.resource.LockResource;
import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.javax.annotation.concurrent.GuardedBy;
import alluxio.wire.WorkerInfo;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface MembershipManager
extends AutoCloseable {
    public static final String PATH_SEPARATOR = "/";

    public void join(WorkerInfo var1) throws IOException;

    public WorkerClusterView getAllMembers() throws IOException;

    public WorkerClusterView getLiveMembers() throws IOException;

    public WorkerClusterView getFailedMembers() throws IOException;

    public String showAllMembers();

    @VisibleForTesting
    public void stopHeartBeat(WorkerInfo var1) throws IOException;

    public void decommission(WorkerInfo var1) throws IOException;

    public static class Factory {
        private static final Logger LOG = LoggerFactory.getLogger(Factory.class);
        private static final Lock INIT_LOCK = new ReentrantLock();
        @GuardedBy(value="INIT_LOCK")
        private static final AtomicReference<MembershipManager> MEMBERSHIP_MANAGER = new AtomicReference();

        public static MembershipManager get(AlluxioConfiguration conf) {
            if (MEMBERSHIP_MANAGER.get() == null) {
                try (LockResource lockResource = new LockResource(INIT_LOCK);){
                    if (MEMBERSHIP_MANAGER.get() == null) {
                        MEMBERSHIP_MANAGER.set(Factory.create(conf));
                    }
                }
            }
            return MEMBERSHIP_MANAGER.get();
        }

        public static MembershipManager create(AlluxioConfiguration conf) {
            switch (conf.getEnum(PropertyKey.WORKER_MEMBERSHIP_MANAGER_TYPE, MembershipType.class)) {
                case STATIC: {
                    return StaticMembershipManager.create(conf);
                }
                case ETCD: {
                    return EtcdMembershipManager.create(conf);
                }
                case MASTER: {
                    return MasterMembershipManager.create();
                }
                case SERVICE_REGISTRY: {
                    return ServiceRegistryMembershipManager.create(conf);
                }
            }
            throw new IllegalStateException("Unrecognized Membership Type");
        }
    }
}

