/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job;

import alluxio.grpc.MoveJobPOptions;
import alluxio.job.JobRequest;
import alluxio.shaded.client.com.fasterxml.jackson.annotation.JsonProperty;
import alluxio.shaded.client.com.google.common.base.MoreObjects;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class MoveJobRequest
implements JobRequest {
    private static final String TYPE = "move";
    private static final long serialVersionUID = -8565405317284410500L;
    private final String mDst;
    private final MoveJobPOptions mOptions;
    private final String mSrc;

    public MoveJobRequest(@JsonProperty(value="src") String src, @JsonProperty(value="dst") String dst, @JsonProperty(value="moveJobPOptions") MoveJobPOptions options) {
        this.mSrc = Preconditions.checkNotNull(src, "The source path cannot be null");
        this.mDst = Preconditions.checkNotNull(dst, "The destination path cannot be null");
        this.mOptions = Preconditions.checkNotNull(options, "The job options cannot be null");
    }

    public String getSrc() {
        return this.mSrc;
    }

    public String getDst() {
        return this.mDst;
    }

    public MoveJobPOptions getOptions() {
        return this.mOptions;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("Src", this.mSrc).add("Dst", this.mDst).add("Options", this.mOptions).toString();
    }

    @Override
    public String getType() {
        return TYPE;
    }
}

