/*
 * Decompiled with CFR 0.152.
 */
package alluxio.file;

import alluxio.annotation.SuppressFBWarnings;
import alluxio.file.ReadTargetBuffer;
import alluxio.shaded.client.io.netty.buffer.ByteBuf;
import alluxio.util.io.ChannelAdapters;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

@SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="The target byte array is exposed as we expect.")
public class ByteArrayTargetBuffer
implements ReadTargetBuffer {
    private final byte[] mTarget;
    private int mOffset;

    public ByteArrayTargetBuffer(byte[] target, int offset) {
        this.mTarget = target;
        this.mOffset = offset;
    }

    @Override
    public byte[] byteArray() {
        return this.mTarget;
    }

    @Override
    public ByteBuffer byteBuffer() {
        return ByteBuffer.wrap(this.mTarget);
    }

    @Override
    public int offset() {
        return this.mOffset;
    }

    @Override
    public void offset(int newOffset) {
        this.mOffset = newOffset;
    }

    @Override
    public long remaining() {
        return this.mTarget.length - this.mOffset;
    }

    @Override
    public void writeBytes(byte[] srcArray, int srcOffset, int length) {
        System.arraycopy(srcArray, srcOffset, this.mTarget, this.mOffset, length);
        this.mOffset += length;
    }

    @Override
    public void writeBytes(ByteBuf buf) {
        int bytesToRead = Math.min(buf.readableBytes(), this.mTarget.length - this.mOffset);
        buf.readBytes(this.mTarget, this.mOffset, bytesToRead);
        this.mOffset += bytesToRead;
    }

    @Override
    public int readFromFile(RandomAccessFile file, int length) throws IOException {
        int bytesRead = file.read(this.mTarget, this.mOffset, length);
        if (bytesRead != -1) {
            this.mOffset += bytesRead;
        }
        return bytesRead;
    }

    @Override
    public int readFromInputStream(InputStream is, int length) throws IOException {
        int bytesRead = is.read(this.mTarget, this.mOffset, length);
        if (bytesRead != -1) {
            this.mOffset += bytesRead;
        }
        return bytesRead;
    }

    @Override
    public WritableByteChannel byteChannel() {
        return ChannelAdapters.intoByteArray(this.mTarget, this.mOffset, this.mTarget.length - this.mOffset);
    }
}

