/*
 * Decompiled with CFR 0.152.
 */
package alluxio.concurrent;

import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

@ThreadSafe
public final class ClientRWLock
implements ReadWriteLock {
    private final Semaphore mAvailable;
    private final AtomicInteger mReferences = new AtomicInteger();
    private final int mMaxReaders;

    public ClientRWLock(int maxReaders) {
        this.mMaxReaders = maxReaders;
        this.mAvailable = new Semaphore(maxReaders, false);
    }

    @Override
    public Lock readLock() {
        return new SessionLock(1);
    }

    @Override
    public Lock writeLock() {
        return new SessionLock(this.mMaxReaders);
    }

    public int getReferenceCount() {
        return this.mReferences.get();
    }

    public void addReference() {
        this.mReferences.incrementAndGet();
    }

    public int dropReference() {
        return this.mReferences.decrementAndGet();
    }

    private final class SessionLock
    implements Lock {
        private final int mPermits;

        private SessionLock(int permits) {
            this.mPermits = permits;
        }

        @Override
        public void lock() {
            ClientRWLock.this.mAvailable.acquireUninterruptibly(this.mPermits);
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            ClientRWLock.this.mAvailable.acquire(this.mPermits);
        }

        @Override
        public boolean tryLock() {
            return ClientRWLock.this.mAvailable.tryAcquire(this.mPermits);
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            return ClientRWLock.this.mAvailable.tryAcquire(this.mPermits, time, unit);
        }

        @Override
        public void unlock() {
            ClientRWLock.this.mAvailable.release(this.mPermits);
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException("newCondition() is not supported");
        }
    }
}

