/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.ufs;

import alluxio.Seekable;
import alluxio.client.file.FileInStream;
import alluxio.exception.PreconditionMessage;
import alluxio.exception.runtime.InternalRuntimeException;
import alluxio.file.SeekableBufferedInputStream;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.shaded.client.com.codahale.metrics.Counter;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.function.Function;

@NotThreadSafe
public class UfsFileInStream
extends FileInStream {
    private static final int BUFFER_SIZE = 0x200000;
    private final long mLength;
    private final Function<Long, InputStream> mFileOpener;
    private Optional<InputStream> mUfsInStream = Optional.empty();
    private long mPosition = 0L;

    public UfsFileInStream(Function<Long, InputStream> fileOpener, long fileLength) {
        this.mFileOpener = Preconditions.checkNotNull(fileOpener);
        this.mLength = fileLength;
    }

    @Override
    public int read() throws IOException {
        if (this.mPosition == this.mLength) {
            return -1;
        }
        this.updateStreamIfNeeded();
        int res = this.mUfsInStream.get().read();
        if (res == -1) {
            return -1;
        }
        ++this.mPosition;
        Metrics.BYTES_READ_FROM_UFS.inc(1L);
        return res;
    }

    @Override
    public int read(ByteBuffer byteBuffer, int off, int len) throws IOException {
        if (byteBuffer.hasArray()) {
            int totalBytesRead = this.read(byteBuffer.array(), off, len);
            if (totalBytesRead > 0) {
                Metrics.BYTES_READ_FROM_UFS.inc(totalBytesRead);
            }
            return totalBytesRead;
        }
        byte[] byteArray = new byte[len];
        int totalBytesRead = this.read(byteArray, 0, len);
        if (totalBytesRead <= 0) {
            return totalBytesRead;
        }
        byteBuffer.position(off).limit(off + len);
        byteBuffer.put(byteArray, 0, totalBytesRead);
        Metrics.BYTES_READ_FROM_UFS.inc(totalBytesRead);
        return totalBytesRead;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        Preconditions.checkArgument(off >= 0 && len >= 0 && len + off <= b.length, PreconditionMessage.ERR_BUFFER_STATE.toString(), (Object)b.length, (Object)off, (Object)len);
        if (len == 0) {
            return 0;
        }
        if (this.mPosition == this.mLength) {
            return -1;
        }
        this.updateStreamIfNeeded();
        int bytesRead = this.mUfsInStream.get().read(b, off, len);
        if (bytesRead > 0) {
            this.mPosition += (long)bytesRead;
        }
        Metrics.BYTES_READ_FROM_UFS.inc(bytesRead);
        return bytesRead;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        long toBeSkipped = Math.min(n, this.mLength - this.mPosition);
        if (!this.mUfsInStream.isPresent()) {
            this.mPosition += toBeSkipped;
            return toBeSkipped;
        }
        long skipped = this.mUfsInStream.get().skip(toBeSkipped);
        if (skipped > 0L) {
            this.mPosition += skipped;
        }
        return skipped;
    }

    @Override
    public long remaining() {
        return this.mLength - this.mPosition;
    }

    @Override
    public int positionedRead(long position, byte[] buffer, int offset, int length) throws IOException {
        this.seek(position);
        return this.read(buffer, offset, length);
    }

    @Override
    public long getPos() throws IOException {
        return this.mPosition;
    }

    @Override
    public void seek(long pos) throws IOException {
        Preconditions.checkArgument(pos >= 0L, "Seek position is negative: %s", pos);
        Preconditions.checkArgument(pos <= this.mLength, "Seek position (%s) exceeds the length of the file (%s)", pos, this.mLength);
        if (this.mPosition == pos) {
            return;
        }
        if (!this.mUfsInStream.isPresent()) {
            this.mPosition = pos;
            return;
        }
        if (this.mUfsInStream.get() instanceof Seekable) {
            ((Seekable)((Object)this.mUfsInStream.get())).seek(pos);
        } else if (this.mPosition < pos) {
            long skipped = 0L;
            do {
                if ((skipped = this.mUfsInStream.get().skip(pos - this.mPosition)) <= 0L) continue;
                this.mPosition += skipped;
            } while (this.mPosition < pos && skipped > 0L);
            if (this.mPosition != pos) {
                throw new InternalRuntimeException(String.format("Failed to use skip to seek to pos %s, current position %s", pos, this.mPosition));
            }
        } else {
            this.close();
        }
        this.mPosition = pos;
    }

    @Override
    public void close() throws IOException {
        if (this.mUfsInStream.isPresent()) {
            this.mUfsInStream.get().close();
            this.mUfsInStream = Optional.empty();
        }
    }

    private void updateStreamIfNeeded() {
        if (this.mUfsInStream.isPresent()) {
            return;
        }
        InputStream ufsInStream = this.mFileOpener.apply(this.mPosition);
        if (this.mLength - this.mPosition >= 0x200000L) {
            ufsInStream = ufsInStream instanceof Seekable ? new SeekableBufferedInputStream(ufsInStream, 0x200000) : new BufferedInputStream(ufsInStream, 0x200000);
        }
        this.mUfsInStream = Optional.of(ufsInStream);
    }

    private static final class Metrics {
        private static final Counter BYTES_READ_FROM_UFS = MetricsSystem.counter(MetricKey.CLIENT_BYTES_READ_FROM_UFS.getName());

        private Metrics() {
        }
    }
}

