/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.dora.netty;

import alluxio.exception.status.AlluxioStatusException;
import java.io.EOFException;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartialReadException
extends IOException {
    private static final Logger LOG = LoggerFactory.getLogger(PartialReadException.class);
    private final int mBytesRead;
    private final int mBytesWanted;
    private final CauseType mCauseType;

    public PartialReadException(int bytesWanted, int bytesRead, CauseType causeType, Throwable cause) {
        super(String.format("Incomplete read due to exception, %d requested, %d actually read", bytesWanted, bytesRead), cause);
        if (!causeType.getType().isInstance(cause)) {
            LOG.error("Failed to read {}, actual read {}", new Object[]{bytesWanted, bytesRead, cause});
            throw new IllegalArgumentException(String.format("Cause type %s is not the instance of cause %s", causeType.getType(), cause));
        }
        this.mBytesRead = bytesRead;
        this.mBytesWanted = bytesWanted;
        this.mCauseType = causeType;
    }

    public int getBytesRead() {
        return this.mBytesRead;
    }

    public int getBytesWanted() {
        return this.mBytesWanted;
    }

    public CauseType getCauseType() {
        return this.mCauseType;
    }

    public static enum CauseType {
        INTERRUPT(InterruptedException.class),
        TIMEOUT(TimeoutException.class),
        SERVER_ERROR(AlluxioStatusException.class),
        TRANSPORT_ERROR(Throwable.class),
        OUTPUT(IOException.class),
        EARLY_EOF(EOFException.class);

        private final Class<? extends Throwable> mCauseType;

        private CauseType(Class<? extends Throwable> type) {
            this.mCauseType = type;
        }

        public Class<? extends Throwable> getType() {
            return this.mCauseType;
        }
    }
}

