/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.dora;

import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.common.collect.ImmutableList;
import alluxio.shaded.client.com.google.common.collect.ImmutableSet;
import alluxio.shaded.client.com.google.common.hash.HashCode;
import alluxio.shaded.client.com.google.common.hash.HashFunction;
import alluxio.shaded.client.com.google.common.hash.Hashing;
import alluxio.shaded.client.javax.annotation.Nullable;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.wire.WorkerIdentity;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;

@VisibleForTesting
@ThreadSafe
public class MultiProbeHashProvider {
    private final int mProbes;
    private final int mMaxAttempts;
    private final long mWorkerInfoUpdateIntervalNs;
    private static final HashFunction HASH_FUNCTION = Hashing.murmur3_32_fixed();
    private final AtomicLong mLastUpdatedTimestamp = new AtomicLong(System.nanoTime());
    private final LongAdder mUpdateCount = new LongAdder();
    private final AtomicReference<Set<WorkerIdentity>> mLastWorkers = new AtomicReference(ImmutableSet.of());
    private static final int SEED = -559038737;
    @Nullable
    private List<Point> mRing;
    private final Object mInitLock = new Object();

    public MultiProbeHashProvider(int maxAttempts, long workerListTtlMs, int probes) {
        this.mMaxAttempts = maxAttempts;
        this.mWorkerInfoUpdateIntervalNs = workerListTtlMs * 1000000L;
        this.mProbes = probes;
    }

    public List<WorkerIdentity> getMultiple(String key, int count) {
        LinkedHashSet<WorkerIdentity> workers = new LinkedHashSet<WorkerIdentity>();
        int attempts = 0;
        while (workers.size() < count && attempts < this.mMaxAttempts) {
            WorkerIdentity selectedWorker = this.get(key, ++attempts);
            workers.add(selectedWorker);
        }
        return ImmutableList.copyOf(workers);
    }

    public void refresh(Set<WorkerIdentity> workers) {
        Set<WorkerIdentity> lastWorkerIds;
        Preconditions.checkArgument(!workers.isEmpty(), "cannot refresh hash provider with empty worker list");
        this.maybeInitialize(workers);
        if (this.shouldRebuildActiveNodesMapExclusively() && !workers.equals(lastWorkerIds = this.mLastWorkers.get())) {
            this.updateActiveNodes(workers, this.mLastWorkers.get());
            this.mLastWorkers.set(workers);
            this.mUpdateCount.increment();
        }
    }

    private boolean shouldRebuildActiveNodesMapExclusively() {
        long lastUpdateTs = this.mLastUpdatedTimestamp.get();
        long currentTs = System.nanoTime();
        if (currentTs - lastUpdateTs > this.mWorkerInfoUpdateIntervalNs) {
            return this.mLastUpdatedTimestamp.compareAndSet(lastUpdateTs, currentTs);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeInitialize(Set<WorkerIdentity> workers) {
        if (this.mRing == null) {
            Object object = this.mInitLock;
            synchronized (object) {
                if (this.mRing == null) {
                    this.build(workers);
                    this.mLastWorkers.set(workers);
                    this.mLastUpdatedTimestamp.set(System.nanoTime());
                }
            }
        }
    }

    private void updateActiveNodes(Set<WorkerIdentity> workers, Set<WorkerIdentity> lastWorkers) {
        HashSet<WorkerIdentity> workerSet = new HashSet<WorkerIdentity>(workers);
        HashSet<WorkerIdentity> lastWorkerSet = new HashSet<WorkerIdentity>(lastWorkers);
        for (WorkerIdentity worker : lastWorkerSet) {
            if (workerSet.contains(worker)) continue;
            this.remove(worker);
        }
        for (WorkerIdentity worker : workerSet) {
            if (lastWorkerSet.contains(worker)) continue;
            this.add(worker);
        }
    }

    @VisibleForTesting
    WorkerIdentity get(String key, int index) {
        Preconditions.checkState(this.mRing != null, "Hash provider is not properly initialized");
        if (this.mRing.isEmpty()) {
            return null;
        }
        int id = this.getIndex(String.format("%s%d", key, index));
        return this.mRing.get((int)id).mResource;
    }

    @VisibleForTesting
    Set<WorkerIdentity> getLastWorkers() {
        return this.mLastWorkers.get();
    }

    @VisibleForTesting
    long getUpdateCount() {
        return this.mUpdateCount.sum();
    }

    @VisibleForTesting
    private void build(Set<WorkerIdentity> workers) {
        Preconditions.checkArgument(!workers.isEmpty(), "worker list is empty");
        this.mRing = new ArrayList<Point>();
        for (WorkerIdentity worker : workers) {
            this.add(worker);
        }
    }

    private void add(WorkerIdentity node) {
        Preconditions.checkState(this.mRing != null, "Hash provider is not properly initialized");
        Point bucket = this.wrap(node);
        int pos = Collections.binarySearch(this.mRing, bucket);
        int index = -(pos + 1);
        this.mRing.add(index, bucket);
    }

    private void remove(WorkerIdentity node) {
        Preconditions.checkState(this.mRing != null, "Hash provider is not properly initialized");
        Point bucket = this.wrap(node);
        int pos = Collections.binarySearch(this.mRing, bucket);
        this.mRing.remove(pos);
    }

    private Point wrap(WorkerIdentity resource) {
        HashCode hashCode = HASH_FUNCTION.newHasher().putObject(resource, WorkerIdentity.HashFunnel.INSTANCE).hash();
        int hash = this.hash(String.format("%d%d", hashCode.asInt(), -559038737));
        return new Point(resource, hash);
    }

    private int hash(String key) {
        return HASH_FUNCTION.hashString(key, StandardCharsets.UTF_8).asInt();
    }

    private int getIndex(String key) {
        int index = 0;
        int minDistance = Integer.MAX_VALUE;
        for (int i = 0; i < this.mProbes; ++i) {
            int distance;
            int hashValue = this.hash(String.format("%s%d", key, i));
            int low = 0;
            int high = this.mRing.size();
            while (low < high) {
                int mid = low + high >>> 1;
                if (this.mRing.get((int)mid).mHash > hashValue) {
                    high = mid;
                    continue;
                }
                low = mid + 1;
            }
            if (low >= this.mRing.size()) {
                low = 0;
            }
            if ((distance = this.mRing.get(low).distance(hashValue)) >= minDistance) continue;
            minDistance = distance;
            index = low;
        }
        return index;
    }

    class Point
    implements Comparable<Point> {
        final WorkerIdentity mResource;
        final int mHash;

        Point(WorkerIdentity resource, int hashValue) {
            this.mResource = resource;
            this.mHash = hashValue;
        }

        int distance(int hash) {
            return Math.abs(this.mHash - hash);
        }

        @Override
        public int compareTo(Point other) {
            return Integer.compare(this.mHash, other.mHash);
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof Point)) {
                return false;
            }
            return Objects.equals(this, other);
        }

        public int hashCode() {
            return this.mHash;
        }
    }
}

